#!/bin/bash

CHK_PASS=0
CHK_FAIL=1
CHK_UNCONCERN=3
CHK_NEEDOPT=4
function getAuthorityLogFile()
{
    echo "/opt/permissionExp.log"
}

function LOG
{
    local logfile="/var/log/inspect.log"
    echo [$(date)][$$]$@ >>${logfile}
}

function checkFileAuthority()
{
    local logfile=$(getAuthorityLogFile)
    local chkfile=""
    local auth=""
    local authInLog=""
    local chkstate=0
    local realAccess=0
    local logAccess=0
    local realUid=0
    local logUid=0
    local realGrp=0
    local logGrp=0
    while read line; do
        chkfile=$(echo "${line}" | awk -F':|->' '{if ($1=="File"){print $2}}')
        if [ -z "${chkfile}" ]; then
            continue
        fi
        read authInLog
        logAccess=$(echo "${authInLog}" | grep -o 'Access:([0-9]\+'); logAccess=${logAccess:8}
        logUid=$(echo "${authInLog}" | grep -o 'Uid:([0-9]\+'); logUid=${logUid:5}
        logGrp=$(echo "${authInLog}" | grep -o 'Gid:([0-9]\+'); logGrp=${logGrp:5}
        #filename0 == access not equal
        #filename2 == file not exist
        #filename3 == auth not equal
        if [ ! -e "${chkfile}" ]; then
            LOG "[$FUNCNAME]: ${chkfile} in /opt/permissionExp.log is not exist."
            echo "filename2:${chkfile}||realmod:--||logmod:${logAccess}||realmod:--||logmod:${logUid}||realmod:--||logmod:${logGrp}"
            chkstate=${CHK_FAIL}
            continue
        fi
        auth=$(stat ${chkfile} | egrep "Uid:" | tr -d "\`' ")
        realAccess=$(echo "${auth}" | grep -o 'Access:([0-9]\+'); realAccess=${realAccess:8}
        realUid=$(echo "${auth}" | grep -o 'Uid:([0-9]\+'); realUid=${realUid:5}
        realGrp=$(echo "${auth}" | grep -o 'Gid:([0-9]\+'); realGrp=${realGrp:5}
        if [ "${auth}" != "${authInLog}" ]; then
            LOG "filename ${chkfile}||real ${auth}||log ${authInLog}"
            if [ "${realAccess}" != "${logAccess}" ]; then
            echo "filename0:${chkfile}||realmod:${realAccess}||logmod:${logAccess}||realmod:${realUid}||logmod:${logUid}||realmod:${realGrp}||logmod:${logGrp}"
            fi
            echo "filename3:${chkfile}||realmod:${realAccess}||logmod:${logAccess}||realmod:${realUid}||logmod:${logUid}||realmod:${realGrp}||logmod:${logGrp}"
            chkstate=${CHK_FAIL}
        fi
    done <${logfile}
    return ${chkstate}
}

function inspectForAuthority()
{
    if [ ! -f /opt/huawei/snas/script/inspect_mml/RecordExpFilePermission.sh ]; then
        LOG "RecordExpFilePermission.sh is not exist. pass."
        return 0
    fi
    sh /opt/huawei/snas/script/inspect_mml/RecordExpFilePermission.sh
    if [ $? -ne 0 ]; then
        return 0 #First create log file
    else
        checkFileAuthority #exec check
    fi
}


inspectForAuthority
exit 0
