#!/bin/bash

tmp_permission="/tmp/tmpfile$$Permission"
LOG_FILE="/var/log/inspect.log"
function LOG
{
   time=$(date)
   echo [${time}][$$]$@ >> $LOG_FILE
}
function checkFileAuthority()
{
    local logfile="${tmp_permission}"
    local chkfile=""
    local curFileMode=""
    local initFileMode=""
    local chkstate=0
    local realAccess=0
    local logAccess=0
    local realUid=0
    local logUid=0
    local realGrp=0
    local logGrp=0
    while read line; do
        chkfile=$(echo "${line}" | awk -F':|->' '{if ($1=="File"){print $2}}')
        if [ -z "${chkfile}" ]; then
            continue
        fi
        read initFileMode
        logAccess=$(echo "${initFileMode}" | grep -o 'Access:([0-9]\+'); logAccess=${logAccess:8}
        logUid=$(echo "${initFileMode}" | grep -o 'Uid:([0-9]\+'); logUid=${logUid:5}
        logGrp=$(echo "${initFileMode}" | grep -o 'Gid:([0-9]\+'); logGrp=${logGrp:5}
        #filename0 == access not equal
        #filename2 == file not exist
        #filename3 == auth not equal
        if [ ! -e "${chkfile}" ]; then
            LOG "[$FUNCNAME]: ${chkfile} in /opt/permissionExp.log is not exist."
            echo "filename2:${chkfile}||realmod:--||logmod:${logAccess}||realmod:--||logmod:${logUid}||realmod:--||logmod:${logGrp}"
            continue
        fi
        curFileMode=$(stat ${chkfile} | egrep "Uid:" | tr -d "\`' ")
        realAccess=$(echo "${curFileMode}" | grep -o 'Access:([0-9]\+'); realAccess=${realAccess:8}
        realUid=$(echo "${curFileMode}" | grep -o 'Uid:([0-9]\+'); realUid=${realUid:5}
        realGrp=$(echo "${curFileMode}" | grep -o 'Gid:([0-9]\+'); realGrp=${realGrp:5}
        if [ "${curFileMode}" != "${initFileMode}" ]; then
            LOG "filename ${chkfile}||real ${curFileMode}||log ${initFileMode}"
            if [ "${realAccess}" != "${logAccess}" ]; then
            echo "filename0:${chkfile}||realmod:${realAccess}||logmod:${logAccess}||realmod:${realUid}||logmod:${logUid}||realmod:${realGrp}||logmod:${logGrp}"
            fi
            echo "filename3:${chkfile}||realmod:${realAccess}||logmod:${logAccess}||realmod:${realUid}||logmod:${logUid}||realmod:${realGrp}||logmod:${logGrp}"
        fi
    done <${logfile}
}


ls /opt/huawei/deploy/script/ |grep -w Record_os_permission.sh >/dev/null
if [ $? -eq 1 ]; then
    echo "S30_get_os_permission.sh not exist,pass."
    exit 0
fi

ls /opt/ |grep -w permission.log >/dev/null
if [ $? -eq 1 ];then
    sh /opt/huawei/deploy/script/Record_os_permission.sh nocheck_ds
    echo "create permission.log success."
    exit 0
fi
#对比cluster_service_type
real_cluster_service_type=$(cat /opt/huawei/snas/etc/snas.ini | grep cluster_service_type | awk -F "=" '{print $2}')
log_cluster_service_type=$(cat /opt/permission.log | grep cluster_service_type | awk -F "=" '{print $2}')
if [ $real_cluster_service_type -ne $log_cluster_service_type ];then
    #不相等则刷新日志文件在匹配
    sh /opt/huawei/deploy/script/Record_os_permission.sh nocheck_ds
fi

cat /opt/permission.log |tr -d "\`"|tr -d "'"|tr -d " " >$tmp_permission
iRet=$?
if [ "$iRet" != "0" ];then
    sleep 1
    cat /opt/permission.log |tr -d "\`"|tr -d "'"|tr -d " " >$tmp_permission
    iRet=$?
    if [ "$iRet" != "0" ];then
        LOG "Get infomation failed.[CheckKeyFileAuthority.sh]"
        exit 1
    fi
fi

checkFileAuthority
#检查log目录下是否有软连接snassh
context=$(find /var/log/ -name snassh)
if [ "X${context}" != "X" ];then
    for line in $context;do
        echo "snassh:$line"
    done
fi

rm $tmp_permission
[ -e /opt/huawei/snas/script/inspect_mml/CheckExpFileAuthority.sh ] && /opt/huawei/snas/script/inspect_mml/CheckExpFileAuthority.sh
exit 0




