#!/bin/bash
LOGFILE="/var/log/inspect.log"


function set_ifs
{
    IFS_OLD=$IFS
    IFS=$'\n'
}

function restore_ifs
{
    IFS=$IFS_OLD
}

function log_file()
{
    echo [`date`][$$]$@ >> $LOGFILE
}

function getlodaldiskinfo()
{
    local tmplocaldiskfile="/tmp/tmpfilelocaldiskinfo"
    local tmpSlotFile="$1"
    if [ -f $tmpSlotFile ];then
        return
    fi
    #生成槽位信息
    /usr/local/bin/MmlBatch 4016 "cm localdiskinfo show" >/dev/null 2>&1
    for i in $(seq 1 60)
    do
        if [ -f "${tmplocaldiskfile}" ];then
            dos2unix ${tmplocaldiskfile} >/dev/null 2>&1
            cat ${tmplocaldiskfile} > $tmpSlotFile 2>&1
            break
        fi
        sleep 1
    done
}

function CheckRHdiskinfo() 
{
    local tmpSlotFile="/tmp/tmpfilelocaldisk$$"
    SNAS_CONFIG_PATH=/opt/huawei/snas/etc/snas.ini
    LOCAL_BACK_IP=`grep ipaddr_1 $SNAS_CONFIG_PATH | awk -F "=" '{print $2}'`
    /opt/huawei/snas/script/inspect_mml/ShowInspectMml $LOCAL_BACK_IP 4016 "cm RHsysdiskslot show" > /tmp/tmpfilesysdiskslot 2>&1

    #smr "[10:0:3:0]   (0x14)  ATA      HGST HSH721414AL TT03  /dev/sde   /dev/sg4"
    #HGST HSH721414AL 中间存在空格,导致$6并不是取的盘符
    javaId=$(lsscsi -g | awk '{if ($1!="[0:0:0:0]" && ($2=="disk" || $2=="(0x14)" || $2=="zbc") && $(NF-1)=="-") print $1}' |tr -d '[] ' |sed 's/^ *//g'|sed "/^$/d")
    #直接重新查系统盘数量,不关注是否是smr, javaId列表包含没有盘符的业务
    count=$(lsscsi -g | awk '{if ($1!="[0:0:0:0]" && $2=="disk" && $(NF-1)=="-") print $1}'| wc -l)
    if [ "$count" != "2" ];then
        isPass=1
    fi

    set_ifs
    for line in $javaId; do
        OS_STAT=`cat /sys/class/scsi_device/$line/device/state 2>&1`
        VENDOR=`cat /sys/class/scsi_device/$line/device/vendor 2>&1`
        MODEL=`cat /sys/class/scsi_device/$line/device/model 2>&1`
        innername=$(lsscsi -g | grep -w "$line"|awk '{print $NF}')
        
        if  [ "$OS_STAT" != "running" ];then
            echo "[ERR]the disk is not running!"
            log_file "[$FUNCNAME][$LINENO]OS_STAT=$OS_STAT"
        fi
        slot=$(cat /tmp/tmpfilesysdiskslot |grep -w "$innername" |awk '{print $2}'|tr -d ' ')
        #对没slot内容的盘,进行业务盘位置查询.如果有数据显示槽位号,并提示业务盘带了raid信息.
        if [ "X$slot" == "X" ];then
            #2块盘的时候,存在坏了一块盘,一块带raid的情况,但如果有一块盘故障,DM上应该有告警.
            #此处补处理这种情况.
            getlodaldiskinfo "${tmpSlotFile}"
            local snline=$(smartctl -i $innername | grep -i "Serial Number:" | awk '{print $3}')
            if [ "X${snline}" != "X" ] && [ -f ${tmpSlotFile} ];then
                slot=$(cat ${tmpSlotFile} | grep "${snline}" | grep -Po '(?<=location: )[0-9]+')
                if [ "X$slot" != "X" ];then
                    isPass=1
                    echo "[ERR]INFO:The service disk in slot $slot contains RAID information." >> ${RESULTFILE} 2>&1
                fi
            fi
        fi
        #状态小写转换成大写
        OS_STAT=`echo $OS_STAT|tr "[:lower:]" "[:upper:]"`
        
        INOUT="--"
        PHY="--"
        POWER="--"
        LED="--"
        OS_IN="--"
        SN="--"
        FW_VER="--"
        LINK="--"
        DISK_SIZE="--"
        SPEED="--"
        TEMP="--"
        TYPE="--"
        echo "SLOT:$slot||INOUT:$INOUT||PHY:$PHY||POWER:$POWER||LED:$LED||OS_IN:$OS_IN||OS_STAT:$OS_STAT||SN:$SN||VENDOR:$VENDOR||FW_VER:$FW_VER||MODEL:$MODEL||LINK:$LINK||DISK_SIZE:$DISK_SIZE||SPEED:$SPEED||TEMP(degrees):$TEMP||TYPE:$TYPE"
        slotcount=$((slotcount+1))
        log_file "[$FUNCNAME][$LINENO]OS_STAT=$OS_STAT,slot=$slot,count=$count"
    done
    restore_ifs
    [ -f $tmpSlotFile ] && rm -f $tmpSlotFile
}
function Checksysdiskinfo()
{
    info=`ipmitool fru | grep 'Product Name' 2>&1`
    iRet=$?
    if [ $iRet -ne 0 ]; then
        echo "[ERR]Failed to execute command(ipmitool fru)."
        return 0
    fi

    #为高密框时
    ANodeInfo=$(echo $info | grep 'OceanStor 9000 C72 Node')
    if [ "$ANodeInfo""X" != "X" ]; then
        RAID=$(cat /proc/mdstat | grep -A1 "active raid1")
        if [ "$RAID" != "" ];then
            find_info=$(echo "${RAID}" |grep "\[2/2\] \[UU\]")
            if [ -z "${find_info}" ]; then
                echo "[ERR]INFO:Software RAID is abnormal."
            else
                echo "INFO:Software RAID is normal."
            fi
        else
            echo "[ERR]INFO:Software RAID hadn't been created."
        fi
        return 0
    fi

    info=`grep SYSTEMDISK /proc/mpt2sas/mpt2sas0-drives 2>&1`
    iRet=$?
    if [ $iRet -ne 0 ]; then
        echo "[ERR]INFO:Failed to get sysdisk info from /proc/mpt2sas/mpt2sas0-drives."
        return 0
    fi
    javaId=`echo "$info"|sed 's/^ *//g'|sed "/^$/d"`
    count=`echo "$info"|wc -l`

    if [ "$count" != "2" ];then
        echo "[ERR]INFO:the number of SystemDisk is not 2"
        log_file "[$FUNCNAME][$LINENO]count=$count"
    fi

    set_ifs
    for line in $javaId; do
        slot=`echo $line|awk '{print $1}'`
        INOUT=`echo $line|awk '{print $2}'`
        PHY=`echo $line|awk '{print $3}'`
        POWER=`echo $line|awk '{print $4}'`
        LED=`echo $line|awk '{print $5}'`
        OS_IN=`echo $line|awk '{print $6}'`
        OS_STAT=`echo $line|awk '{print $7}'`
        SN=`echo $line|awk '{print $8}'`
        VENDOR=`echo $line|awk '{print $9}'`
        FW_VER=`echo $line|awk '{print $10}'`
        MODEL=`echo $line|awk '{print $11}'`
        LINK=`echo $line|awk '{print $12}'`
        DISK_SIZE=`echo $line|awk '{print $13}'`
        SPEED=`echo $line|awk '{print $14}'`
        TEMP=`echo $line|awk '{print $15}'`
        TYPE=`echo $line|awk '{print $16}'`

        #判断状态， LED    OS_IN    OS_STAT
        if  [ "$LED" != "0" ] || [ "$OS_IN" != "1" ] || [ "$OS_STAT" != "running" ];then
            echo "[ERR]INFO:the sysdisk is abnormal in the SLOT($slot)"
        fi

        #状态小写转换成大写
        OS_STAT=`echo $OS_STAT|tr "[:lower:]" "[:upper:]"`
        echo "SLOT:$slot||INOUT:$INOUT||PHY:$PHY||POWER:$POWER||LED:$LED||OS_IN:$OS_IN||OS_STAT:$OS_STAT||SN:$SN||VENDOR:$VENDOR||FW_VER:$FW_VER||MODEL:$MODEL||LINK:$LINK||DISK_SIZE:$DISK_SIZE||SPEED:$SPEED||TEMP(degrees):$TEMP||TYPE:$TYPE"
    done
    restore_ifs 
}


function checksystemdisk()
{
    local ProductName=$(dmidecode -t 1 | grep "Product Name:" | awk '{print $3}')
    log_file "ProductName=$ProductName"
    if [ "$ProductName" = "RH2288" -o "$ProductName" = "5288" -o "$ProductName" = "RH2288H" ]; then
        CheckRHdiskinfo
    else
        Checksysdiskinfo
    fi
        
}
        
checksystemdisk
exit 0