#!/bin/bash
LOGFILE="/var/log/inspect.log"

function IsRHNode()
{
    local name=''
    name=$(dmidecode -t 1 | grep "Product Name:" | awk '{print $3}')
    if [ "$name" = "RH2288" -o "$name" = "5288" -o "$name" = "RH2288H" ]; then
        return 0
    else
        return 1
    fi
}

function log_file()
{
    echo [$(date)][$$]$@ >> $LOGFILE
}
IsRHNode
#ֻRHм⣬ӲͶ漰
if [ $? -eq 1 ];then
    echo "SesFwVersion:no need to check."
    exit 0
fi
source /opt/huawei/snas/upd/upd_fw/rhfw/ses_utility.sh
#ļses_utility.shǲ޸ ڸļϿ֮ǰ ѲҪ׽ ҪIsRH5288_36()
function IsRH5288_36()
{
    local device_type=""
    IsRHNode
    if [ $? -ne 0 ];then
        return 1
    fi

    device_type=$(cat /opt/huawei/snas/etc/snas.ini | grep "nodeType" | awk -F "=" '{print $2}')
    if [ "$device_type" == "14" -o "$device_type" == "15" -o "$device_type" == "16" -o "$device_type" == "17" ];then
        return 0
    fi

    return 1
}

SESinfo=$(GetsesFwVer)
if [ "$SESinfo" = "" ];then
    log_file "[$FUNCNAME]can not get SESfwversion information"
    exit 1
fi
if [ "$SESinfo" = "120" ];then
    echo "[ERR]The SesVersion($SESinfo) is in black list"
    log_file "[$FUNCNAME]The SesVersion($SESinfo) is in black list"
else
    echo "SesFwVersion:$SESinfo"  
fi
exit 0

