#!/bin/bash

function getAuthorityLogFile()
{
    echo "/opt/permissionExp.log"
}

g_includeDirList=(
/opt/huawei/deploy
/opt/huawei/snas
)

g_excludeFileList=(
/opt/huawei/deploy/package
/opt/huawei/snas/etc/monstore
/opt/huawei/snas/etc/monstorebase
/opt/huawei/snas/monstore_bakup
/opt/huawei/snas/monstorebase_bakup
/opt/huawei/snas/etc_old
/opt/huawei/snas/static_old
/opt/huawei/snas/map_rollback
/opt/huawei/snas/etc/map_backup
)


function log()
{
    local logfile="/var/log/inspect.log"
    echo $(date "+%Y-%m-%d %H:%M:%S") $@ >> ${logfile}
}


function recordFileAuthority()
{
    local logfile=$(getAuthorityLogFile)
    local i_include=0;
    local i_exclude=0;
    local findPath=""
    local excludeList=""
    while [ ${i_include} -lt ${#g_includeDirList[@]} ]; do
        findPath=${g_includeDirList[${i_include}]}
        if [ ! -d "${findPath}" ]; then
            i_include=$((i_include + 1))
            continue
        fi
        i_exclude=0
        excludeList=""
        while [ ${i_exclude} -lt ${#g_excludeFileList[@]} ]; do
            if [[ "${g_excludeFileList[${i_exclude}]}" =~ "${findPath}" ]]; then
                if [ -z "$excludeList" ]; then
                    excludeList="\( -path \"${g_excludeFileList[${i_exclude}]}\""
                else
                    excludeList="${excludeList} -o -path \"${g_excludeFileList[${i_exclude}]}\""
                fi
            fi
            i_exclude=$((i_exclude + 1))
        done
        [ -n "$excludeList" ] && excludeList="${excludeList} \) -prune"
        eval "find ${findPath} ${excludeList} -o -exec stat {} \;" | egrep "File:|Uid:" | tr -d "\`' "  >>${logfile}
        i_include=$((i_include + 1))
    done
}

function createAuthorityLog()
{
    local logfile=$(getAuthorityLogFile)
    local serviceType=""
    local serviceTypeInLog=""
    local ver=""
    local verInLog=""
    if [ -f ${logfile} ];then
        [ -f /opt/huawei/snas/etc/snas.ini ] && serviceType=$(grep node_service_type /opt/huawei/snas/etc/snas.ini)
        serviceTypeInLog=$(head -2 ${logfile} | grep node_service_type)
        [ -f /opt/huawei/deploy/package/version ] && ver=$(grep ProductVersion /opt/huawei/deploy/package/version)
        verInLog=$(head -2 ${logfile} | grep ProductVersion)

        if [ "${serviceType}" = "${serviceTypeInLog}" -a "${ver}" = "${verInLog}" ]; then
            log "No need excute RecordExpFilePermission"
            return 0
        fi

        log "Excute RecordExpFilePermission begin"
        rm ${logfile}
        echo "${serviceType}" >${logfile}
        echo "${ver}" >>${logfile}
        recordFileAuthority
        log "Excute RecordExpFilePermission end"
        return 1
    else
        log "Excute RecordExpFilePermission begin"
        [ -f /opt/huawei/snas/etc/snas.ini ] && serviceType=$(grep node_service_type /opt/huawei/snas/etc/snas.ini)
        [ -f /opt/huawei/deploy/package/version ] && ver=$(grep ProductVersion /opt/huawei/deploy/package/version)
        echo "${serviceType}" >${logfile}
        echo "${ver}" >>${logfile}
        recordFileAuthority
        log "Excute RecordExpFilePermission end"
        return 1
    fi
}

createAuthorityLog
