#!/bin/bash

G_REMOTE_TMP_FILE="/tmp/tmpfile"
G_MML_FILE_PATH="/opt/huawei/snas/script/inspect_mml/"
LOG_FILE="/var/log/inspect.log"
isPass=0

function LOG 
{
   time=$(date)
   echo [${time}][$$]$@ >> $LOG_FILE
}



#===  FUNCTION  ================================================================
#         NAME: TryRunCmd
#      PURPOSE: 执行指定命令. 尝试执行指定次数,如果有执行成功(退出值为0)则退出返回0;
#                             如果每次都失败退出返回1
#   PARAMETERS: $1= 最大执行次数
#               $2= 每次执行命令失败后的延时
#               $3= 需要执行的命令
#      RETURNS: 0-成功
#               1-失败
#  DESCRIPTION: examples:
#===============================================================================
function TryRunCmd()
{
    #参数检查
    if [[ $# -ne 3 ]]; then
        LOG "ERROR:Parameters count($#) error, should be 3 parameters.('$@' | ${BASH_SOURCE[1]}:${BASH_LINENO[0]})" "$FUNCNAME" "$scriptName"
        return 1
    else
        if [[ ! "$1" =~ ^[0-9]+$ ]] || [[ $1 < 1 ]]; then
            LOG "ERROR:Parameter 1 '$1' should be number and > 0.('$@' | ${BASH_SOURCE[1]}:${BASH_LINENO[0]})" "$FUNCNAME" "$scriptName"
            return 1
        elif [[ ! "$2" =~ ^[0-9]+$ ]] || [[ $1 < 0 ]]; then
            LOG "ERROR:Parameter 2 '$2' should be number and >= 0.('$@' | ${BASH_SOURCE[1]}:${BASH_LINENO[0]})" "$FUNCNAME" "$scriptName"
            return 1
        elif [[ -z "$3" ]]; then
            LOG "ERROR:Parameter 3 '$3' is empty.('$@' | ${BASH_SOURCE[1]}:${BASH_LINENO[0]})" "$FUNCNAME" "$scriptName"
            return 1
        fi
    fi

    local max=$1
    local sleeptime=$2
    local cmd=$3
    local ret=0
    local i=0
    #执行命令
    for (( i=1; i<=$max; i++))
    do
        eval "$cmd" >> "$LOG_FILE" 2>&1
        ret=$?
        if [[ ("$ret" = 0) || ("$i" = "$max") ]] ; then
            break
        fi
        sleep $sleeptime
    done

    if [ "$ret" -ne 0 ]; then
        LOG "ERROR:TryRunCmd failed($i times):'$3'. (${BASH_SOURCE[1]}:${BASH_LINENO[0]})"
        return 1
    fi

    LOG "INFO:TryRunCmd success($i times):'$3'. (${BASH_SOURCE[1]}:${BASH_LINENO[0]})"
    return 0
}

managenetinfo=`sudo cat /opt/huawei/snas/etc/cm.ini`
frontnetinfo=`sudo cat /opt/huawei/deploy/script/deploy_source_route.sh`
if [ $? -ne 0 ]
then
    ShellLogError "get the ip address of gateway failed"
    exit 1
fi

mgipv4GateWay=$(echo "${managenetinfo}" | grep "omGateway=" | awk -F "=" '{print $2}'|uniq)
mgipv6GateWay=$(echo "${managenetinfo}" | grep "omGateway_v6=" | awk -F "\"" '{print $2}'|uniq)
frontipv4GateWay=$(echo "${frontnetinfo}" | grep  "ip route add default via"| awk -F " " '{print $6}'|uniq)
frontipv6GateWay=$(echo "${frontnetinfo}" | grep "ip -6 route add default via"| awk -F " " '{print $7}'|uniq)
gatewaysipv4=($mgipv4GateWay $frontipv4GateWay)
gatewaysipv6=($mgipv6GateWay $frontipv6GateWay)
iptype=""
function checknodeip()
{
    idList=$(cat "/opt/huawei/snas/etc/snas.ini" |tr \\n ] |grep -Po '(?<=[[]NETWORK[]]).*' |tr ] \\n |grep -P "^subnetwork_id_")
    if [ ! -z "$idList" ]; then
        for idParam in $idList
        do
            num=$(echo $idParam |awk -F "=" '{print $2}')
            if [ "$num" -eq 2 ] ; then
                key=$(echo $idParam |awk -F "=" '{print $1}' | awk -F "subnetwork_id_" '{print $2}')
                if [ ! -z "$key" ]; then
                    netbond_mgr=$(cat "/opt/huawei/snas/etc/snas.ini" |tr \\n ] |grep -Po '(?<=[[]NETWORK[]]).*' |tr ] \\n |grep -Po "(?<=^ipaddr_${key}=).*" |awk 'NR==1{print}') 
                    break
                fi
            fi
        done
    fi
    echo "$netbond_mgr" | grep -E "^((25[0-5]|2[0-4][0-9]|([1-9][0-9]?)|(1[0-9][0-9]?))\.)((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){2}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$" >/dev/null 2>&1
    if [ $? -eq 0 ]; then
        iptype="ipv4"
    fi
    echo "$netbond_mgr" | grep -E "^(((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3}))|:)))(%.+)?)$" >/dev/null 2>&1
    if [ $? -eq 0 ]; then
        iptype="ipv6"
    fi
}
function checkIsConnectible()
{
    if [ iptype == "ipv4" ];then
        for ipAddr in ${gatewaysipv4[@]}
        do
            if [ -z "$ipAddr" ]
            then
                LOG "$ipAddr is null"
            else 
                #执行ping 网关，最多执行5次，每次间隔10秒。任意一次成功，则该网关可达；连续5次失败，则该网关不可达。
                res=$(TryRunCmd 5 10 "ping -c 5 ${ipAddr}" 2>&1)
                if [ $? -ne 0 ]; then
                    LOG "ERROR:check gateway($ipAddr) time out. detail: $res" "$FUNCNAME" "${scriptName}"
                    echo "[ERR]ping gateway($ipAddr) time out."
                    return 1
                fi
                LOG "INFO: check gateway($ipAddr) ok." "$FUNCNAME" "${scriptName}"
            fi
        done
    fi
    if [ iptype == "ipv6" ];then
        for ipAddr in ${gatewaysipv6[@]}
        do
            if [ -z "$ipAddr" ]
            then
                LOG "$ipAddr is null"
            else 
                #执行ping 网关，最多执行5次，每次间隔10秒。任意一次成功，则该网关可达；连续5次失败，则该网关不可达。
                res=$(TryRunCmd 5 10 "ping6 -c 5 ${ipAddr}" 2>&1)
                if [ $? -ne 0 ]; then
                    LOG "ERROR:check gateway6($ipAddr) time out. detail: $res" "$FUNCNAME" "${scriptName}"
                    echo "[ERR]ping gateway($ipAddr) time out."
                    return 1
                fi
                LOG "INFO: check gateway6($ipAddr) ok." "$FUNCNAME" "${scriptName}"
            fi
        done
    fi
    return 0
}

function check_routesfile()
{
    #检查/dev/.sysconfig/network route-stack-* 是否超过100
    local ret=0
    local tmpNum=$(find /dev/.sysconfig/network -type f -name "route-stack-*" | wc -l)
    if [ $tmpNum -gt 100 ]; then
        ret=1
        echo "[ERR]The number of files(/dev/.sysconfig/network route-stack-XXX) is great than 100."
    fi
    return $ret
}
function CheckManagementIP()
{
    local errResult=""
    local cluster_om_ip=""
    local cluster_om_ipv4=$(grep -Po '(?<=^omip=)[0-9.]*' /opt/huawei/snas/etc/cm.ini)
    local cluster_om_ipv6=$(grep -Po '(?<=^omip_v6=).*' /opt/huawei/snas/etc/cm.ini | sed 's/"//g')
    local mylocalip=""
    local mylocalipv4=$(grep -Po '(?<=^Localomip=)[0-9.]*' /opt/huawei/snas/etc/cm.ini)
    local mylocalipv6=$(grep -Po '(?<=^Localomip_v6=).*' /opt/huawei/snas/etc/cm.ini | sed 's/"//g')
    local productVersion=$(grep ProductVersion /opt/huawei/deploy/package/version |awk -F= '{print $2}')
    local port_omCard="NULL"
    local port_LocalOMCard="NULL"
    local port_LocalOMCard_v6="NULL"
    if [ "X${mylocalipv4}" = "X" -a "X${mylocalipv6}" = "X" ];then
        mylocalip="NULL"
    else
        local routeIp=$(ip route show table om1 | awk '{print $NF}' | head -1)
        local isOnLocalNode=$(ip addr | grep -wF "${routeIp}")
        if [ "X${isOnLocalNode}" = "X" ];then
            isPass=1
            errResult="[ERR]INFO:Management route error."
            echo "$errResult">>${RESULTFILE} 2>&1
        fi
        port_omCard=$(grep -Po '(?<=^omCard=).*' /opt/huawei/snas/etc/cm.ini | sed 's/"//g')
        if [ "X${port_omCard}" = "X" ];then
            LOG "omCard is null in cm.ini."
            isPass=1
            errResult="[ERR]INFO:The cluster omCard is null in cm.ini"
            echo "$errResult" >>${RESULTFILE} 2>&1
            return 0
        fi
        if [ "X${cluster_om_ipv4}" != "X" ];then
            port_LocalOMCard=$(grep -Po '(?<=^LocalOMCard=).*' /opt/huawei/snas/etc/cm.ini | sed 's/"//g')
            if [ "X${port_LocalOMCard}" != "X" ] && [ "X${port_omCard}" != "X${port_LocalOMCard}" ];then
                isPass=1
                errResult="[ERR]INFO:The cluster management IP(${port_omCard}) and local management IP(${port_LocalOMCard}) are on different network ports."
                echo "$errResult" >>${RESULTFILE} 2>&1
            fi
        elif [ "X${cluster_om_ipv6}" != "X" ];then
            port_LocalOMCard_v6=$(grep -Po '(?<=^LocalOMCard_v6=).*' /opt/huawei/snas/etc/cm.ini | sed 's/"//g')
            if [ "X${port_LocalOMCard_v6}" != "X" ] && [ "X${port_omCard}" != "X${port_LocalOMCard_v6}" ];then
                isPass=1
                errResult="[ERR]INFO:The cluster management IP(${port_omCard}) and local management IP(${port_LocalOMCard_v6}) are on different network ports."
                echo "$errResult" >>${RESULTFILE} 2>&1
            fi
        else
            isPass=1
            errResult="[ERR]INFO:The cluster management IP is null."
            echo "$errResult" >>${RESULTFILE} 2>&1
        fi
    fi
}
function isZeroDomain()
{
    local domainID=$(grep SubDomain /opt/huawei/snas/etc/cm.ini|awk -F "=" '{print $2}')
    return $domainID
}
isZeroDomain
if [ $? -eq 0 ]; then
    CheckManagementIP
else
    LOG "$(hostname) isn't in subdomian of zero.(CheckManagementIP)"
fi
check_routesfile
ret1=$?
checknodeip
checkIsConnectible
ret=$?

if [ $ret -eq 0 ] && [ $ret1 -eq 0 ] && [ $isPass -eq 0 ];then
   msg="check gateway success"
else
   msg="check gateway fail"
fi
echo "${msg}"
