#!/bin/bash

source /opt/obs/scripts/common/snas_aes_util.sh

export LD_LIBRARY_PATH="/opt/huawei/gaussdb/app/lib"
###
#功    能：桶信息长时间处于中间状态巡检项
#输入参数：无
#标准输出：打印信息显示
#          para:${value}
#          Result:${res} 0:正常； 非0:不正常 （默认使用1）
###
#CM_INI_PATH
readonly CM_INI_PATH="/opt/huawei/snas/etc/cm.ini"
G_REMOTE_TMP_FILE="/tmp/tmpfile"
G_MML_FILE_PATH="/opt/huawei/snas/script/inspect_mml/"
LOG_FILE="/var/log/inspect.log"
readonly PRIMARY_TYPE="Primary"    #主
readonly STANDBY_TYPE="Standby"    #备
readonly BUSINESS_TYPE="Business"  #业务节点
function LOG 
{
   time=$(date)
   echo [${time}][$$]$@ >> $LOG_FILE
}



#脚本执行正常返回码0
RESULT_CODE_OK=0
#脚本执行异常返回码1
RESULT_CODE_ERR=1

value=""
res=$RESULT_CODE_OK

######################################################################
#   FUNCTION   : is_node_active
#   DESCRIPTION: HA主节点判断
#   INPUT      : 无
#   OUTPUT     : 判断该节点是否需要检查,返回：0，需要检查；1，不需要检查
######################################################################
function is_node_active()
{
    local isNotNeedCheck=0
    #获取节点类型标识
    local node_service_type=$(egrep '[[]|^'node_service_type'=' /opt/huawei/snas/etc/snas.ini | tr -d '\n' | grep -Po '(?<=[[]'NODE'[]]'node_service_type'=)[0-9]+')
    if [ "${node_service_type}" = "2" -o "${node_service_type}" = "3" ]; then
    
        source /opt/obs/scripts/common/s3_config_utility.sh >> /dev/null 2>&1 
        #判断是否是s3管理节点
        is_s3_management_node > /dev/null
        if [ $? -eq 1 ]; then
            local localNID=$(grep -w NID ${CM_INI_PATH}|awk -F"=" '{print $2}')
            if [ -z "$localNID" ]; then
               LOG "INFO: the localNID is null" "$FUNCNAME" "${scriptName}"
            else
                local hainfo=$(grep -w "node id(${localNID})" /proc/monc_hamap)
                if [ "$hainfo" = "" ];then
                    LOG "INFO: the nodetype is $BUSINESS_TYPE" "$FUNCNAME" "${scriptName}"
                    isNotNeedCheck=1 
                else
                    role=${hainfo##*role(}
                    role=${role%%)status*}
                    
                    if [ "$role" = "1" ];then
                        LOG "INFO: the nodetype is $PRIMARY_TYPE" "$FUNCNAME" "${scriptName}"
                    elif [ "$role" = "2" ];then
                        isNotNeedCheck=1
                        LOG "INFO: the nodetype is $STANDBY_TYPE" "$FUNCNAME" "${scriptName}"
                    fi
                fi
            fi
        else
            isNotNeedCheck=1
        fi        
    else
        isNotNeedCheck=1      
    fi
    return $isNotNeedCheck
	
}

######################################################################
#   FUNCTION   : checkMdcMiddle
#   DESCRIPTION: 桶信息长时间处于中间状态判断
#   INPUT      : 无
#   OUTPUT     : 无
######################################################################
function checkMdcMiddle()
{
    mdcdbUserPwdStr=$(/opt/obs/scripts/common/commonfunction.sh getMdcdbUserPwdStr)
    mdcdbUserPwdStr_prefix=`splitPwdPreFromStr "$mdcdbUserPwdStr"`
    mdcdbUserPwdStr_pwd=`splitPwdFromStr "$mdcdbUserPwdStr"`
    
    #TAG_WITHOUT_AES_TOOL_BEGIN
    if [[ -z "$mdcdbUserPwdStr" ]]
    then
        local bucktable=`sudo -u gaussdba /opt/huawei/gaussdb/app/bin/gsql -d locations -p 5679 $mdcdbUserPwdStr \
                        -c "select * from LOCATIONTABLE;" \
                        2>/dev/null`
    else
        aes_cmd="sudo -u gaussdba /opt/huawei/gaussdb/app/bin/gsql -d locations -p 5679 $mdcdbUserPwdStr_prefix \$(echo '<<placeholder>>' | base64 -d) \
                        -c \"select * from LOCATIONTABLE;\" \
                        2>/dev/null"
        local bucktable=$(echo $mdcdbUserPwdStr_pwd | $SNAS_CMD_TOOL -D "$aes_cmd")
    fi
    #TAG_WITHOUT_AES_TOOL_END    
	
	local bucknum=`echo "$bucktable" | grep -E -v "^$" | awk 'END{print NR}'`
    local currentTimeStamp=`date --date -2hour +%s`
    #TAG_WITHOUT_AES_TOOL_BEGIN
    if [[ -z "$mdcdbUserPwdStr" ]]
    then
        local gsql_res=`sudo -u gaussdba /opt/huawei/gaussdb/app/bin/gsql -A -t -d cloud_mdc -p 5679 $mdcdbUserPwdStr \
                        -c "select (LAST_MODIFIED - to_date('1970-01-01 00:00:00','yyyy-mm-dd hh24:mi:ss')) \
                        * 86400 as timestamp from bucket_location_info where status not in (3,6);" \
                        2>/dev/null | grep "days" | awk '{print $1}' | sed 's/^[ \t]*//g' | sed 's/[ \t]*$//g'`
    else
        aes_cmd="sudo -u gaussdba /opt/huawei/gaussdb/app/bin/gsql -d cloud_mdc -p 5679  -A -t $mdcdbUserPwdStr_prefix \$(echo '<<placeholder>>' | base64 -d) \
                        -c \"select (LAST_MODIFIED - to_date('1970-01-01 00:00:00','yyyy-mm-dd hh24:mi:ss')) \
                        * 86400 as timestamp from bucket_location_info where status not in (3,6);\" \
                        2>/dev/null | grep \"days\" | awk '{print \$1}' | sed 's/^[ \t]*//g' | sed 's/[ \t]*$//g'"
        local gsql_res=$(echo $mdcdbUserPwdStr_pwd | $SNAS_CMD_TOOL -D "$aes_cmd")
    fi
    #TAG_WITHOUT_AES_TOOL_END    
    local tmpFileLineNum=`echo "$gsql_res" | grep -E -v "^$" | awk 'END{print NR}'`
    local timeoutCount=0
    
	if [ $bucknum -eq 0 ]
	then 
		value="${value},There is no bucket"
        LOG "There is no bucket" "INFO" "${scriptName}"
    elif [ $tmpFileLineNum -eq 0 ]
    then
        value="${value},All buckets are ready or deleted state"
        LOG "All buckets are ready or deleted state" "INFO" "${scriptName}"
    else
        while read line
        do
            if [ $currentTimeStamp -gt $line ]
            then
                let timeoutCount++
            fi
        done <<< "`echo "$gsql_res" | grep -E -v "^$"`"
        
        if [ $timeoutCount -ne 0 ]
        then
            res=$RESULT_CODE_ERR
            value="${value},last_modified:timeout"
            LOG "last_modified:timeout" "ERROR" "${scriptName}"
        else
            value="${value},The intermediate state less than 2 hours"
            LOG "The intermediate state less than 2 hours" "INFO" "${scriptName}"
        fi
    fi
}

function main()
{
	#HA主节点判断
    is_node_active
    if [ $? -ne 0 ]
    then
        LOG "standby-HA nodes do not need to inspect" "INFO" "${scriptName}"
        value="${value},standby-HA nodes do not need to inspect"
		
    else
        #桶信息长时间处于中间状态判断
        checkMdcMiddle
    fi
    
    echo "${value}" | grep "^," >/dev/null 2>&1
    if [ $? -eq 0 ]
    then
        value="${value#?}"
    fi
    LOG "result=${res};value=${value};" "INFO" "${scriptName}"
	line="$res$value"
	if [ -z "$line" ]
    then
        value="no inspect file"
        res="Fail"
        LOG "no inspect file" "ERROR" "${scriptName}"
    else
		value="${value#*value=}"
        if [ ${res} -eq 0 ]
        then
            res="Pass"
        else
            res="Fail"
        fi
    fi
    LOG "${value}" "INFO" "${scriptName}"
    LOG "Result:${res}" "INFO" "${scriptName}"
}

main
echo "${value}"
echo "Result:${res}"
