#!/bin/bash
###
#功    能：DNS业务状态及region域名和website域名巡检项
#输入参数：无
#标准输出：打印信息显示
#          para:${value}
#          Result:${res} 0:正常； 非0:不正常 （默认使用1）
###
#CM_INI_PATH
readonly CM_INI_PATH="/opt/huawei/snas/etc/cm.ini"
G_REMOTE_TMP_FILE="/tmp/tmpfile"
G_MML_FILE_PATH="/opt/huawei/snas/script/inspect_mml/"
LOG_FILE="/var/log/inspect.log"
readonly PRIMARY_TYPE="Primary"    #主
readonly STANDBY_TYPE="Standby"    #备
readonly BUSINESS_TYPE="Business"  #业务节点
function LOG 
{
   time=$(date)
   echo [${time}][$$]$@ >> $LOG_FILE
}


#巡检通过
RESULT_PASS="Pass"
#巡检失败
RESULT_FAIL="Fail"

obs_sod_properties_content=`sudo cat /opt/obs/obsconf/obs_sod.properties`
multiaz_ini_content=`sudo cat /opt/huawei/snas/etc/multiaz.ini`
lshelper_content=`sudo cat /opt/huawei/snas/script/LsHelper.py`
answer_sec=""
value=""
res=$RESULT_PASS

######################################################################
#   FUNCTION   : is_node_active
#   DESCRIPTION: HA节点判断
#   INPUT      : 无
#   OUTPUT     : 判断该节点是否需要检查,返回：0，需要检查；1，不需要检查
######################################################################
function is_node_active()
{
    local isNotNeedCheck=0
    #获取节点类型标识
    local node_service_type=$(egrep '[[]|^'node_service_type'=' /opt/huawei/snas/etc/snas.ini | tr -d '\n' | grep -Po '(?<=[[]'NODE'[]]'node_service_type'=)[0-9]+')
    if [ "${node_service_type}" = "2" ]; then
    
        source /opt/obs/scripts/common/s3_config_utility.sh >> /dev/null 2>&1 
        #判断是否是s3管理节点
        is_s3_management_node > /dev/null
        if [ $? -eq 1 ]; then
            local localNID=$(grep -w NID ${CM_INI_PATH}|awk -F"=" '{print $2}')
            if [ -z "$localNID" ]; then
               LOG "INFO: the localNID is null" "$FUNCNAME" "${scriptName}"
            else
                local hainfo=$(grep -w "node id(${localNID})" /proc/monc_hamap)
                if [ "$hainfo" = "" ];then
                    LOG "INFO: the nodetype is $BUSINESS_TYPE" "$FUNCNAME" "${scriptName}"
                    isNotNeedCheck=1 
                else
                    role=${hainfo##*role(}
                    role=${role%%)status*}
                    
                    if [ "$role" = "1" ];then
                        LOG "INFO: the nodetype is $PRIMARY_TYPE" "$FUNCNAME" "${scriptName}"
                    elif [ "$role" = "2" ];then
                        LOG "INFO: the nodetype is $STANDBY_TYPE" "$FUNCNAME" "${scriptName}"
                    fi
                fi
            fi
        else
            isNotNeedCheck=1
        fi        
    else
        isNotNeedCheck=1      
    fi
    return $isNotNeedCheck
}
######################################################################
#   FUNCTION   : dig_domain
#   DESCRIPTION: 域名解析
#   INPUT      : 域名
#   OUTPUT     : 无
######################################################################
function dig_domain()
{
    local domain="$1"
    answer_sec="answer_section"

    while read line
    do
        echo "$line" | grep -E "^((25[0-5]|2[0-4][0-9]|([1-9][0-9]?)|(1[0-9][0-9]?))\.)((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){2}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$" >/dev/null 2>&1
        if [ $? -eq 0 ]
        then
            answer_sec="$answer_sec,$line"
        fi
    done <<< "`dig "${domain}" A +noall +answer +short | sed 's/^[ \t]*//g' | sed 's/[ \t\r\n]*$//g'`"

    if [[ "X$answer_sec" == "Xanswer_section" ]]
    then
        res=$RESULT_FAIL
        answer_sec="$answer_sec,null"
    fi
    answer_sec="${answer_sec/,/:}"
    
}

######################################################################
#   FUNCTION   : dig_dns_domain
#   DESCRIPTION: DNS域名解析
#   INPUT      : 无
#   OUTPUT     : 无
######################################################################
function dig_dns_domain()
{
    local dns_domain=`echo "$obs_sod_properties_content" | grep "obs_api_root_domain_name" | cut -d'=' -f2 \
                        | sed 's/^[ \t]*//g' | sed 's/[ \t\r\n]*$//g'`
    local pname=`cat /opt/huawei/snas/etc/snas.ini | grep 'productType=' | awk -F '=' '{print $2}' \
                        | sed 's/^[ \t]*//g' | sed 's/[ \t\r\n]*$//g'`
    local GlobalEndPoint=`echo "$multiaz_ini_content" | grep -e "^GlobalEndPoint=" | awk -F"=" '{print $2}' \
                        | sed 's/^[ \t]*//g' | sed 's/[ \t\r\n]*$//g'`
    if [ "X$pname" == "X80" ]
    then
        if [ -z "${GlobalEndPoint}" ]
        then
            value="${value},Global domain name is not configured"
            LOG "INFO: Global domain name is not configured" "$FUNCNAME" "${scriptName}"
        else
            if [ -z "${dns_domain}" ]
            then
                value="${value},Global domain name is null"
                LOG "INFO: Global domain name is null" "$FUNCNAME" "${scriptName}"
            else
                value="${value},obs_api_root_domain_name:${dns_domain}"
                answer_sec=""
                dig_domain "$dns_domain"
                value="${value},${answer_sec}"
            fi
        fi
    else
        if [ -z "${dns_domain}" ]
            then
                value="${value},Global domain name is null"
                LOG "INFO: Global domain name is null" "$FUNCNAME" "${scriptName}"
            else
                value="${value},obs_api_root_domain_name:${dns_domain}"
                answer_sec=""
                dig_domain "$dns_domain"
                value="${value},${answer_sec}"
            fi
    fi
}

######################################################################
#   FUNCTION   : dig_region_website_domain
#   DESCRIPTION: region/website域名解析
#   INPUT      : 无
#   OUTPUT     : 无
######################################################################
function dig_region_domain()
{
    local region_id=`echo "$multiaz_ini_content" | grep -e "^Region=" | awk -F"=" '{print $2}'`
    
    if [ -z "${region_id}" ]
    then
        value="${value},region_id is null"
        LOG "INFO: region_id is null" "$FUNCNAME" "${scriptName}"
    else
        aksk=`/opt/huawei/snas/script/LsHelper.py ADMIN GET`
        tag="${aksk:0:1}"
        #tag == '{'那么aksk获取失败
        retry=0
        while [ $retry -lt 3 ]
        do
            retry=$(($retry+1))
            if [[ $tag == '{' ]]
            then
                sleep 1
                continue
            else 
                break
            fi
        done
        if [ $retry -gt 3 ]
        then
            value="${value},get admin info result is: $aksk, fail to get admin ak"
            LOG "INFO: get admin info result is: $aksk, fail to get admin ak" "$FUNCNAME" "${scriptName}"
        fi
        i=`expr index $aksk ':'` 
        ak=${aksk:0:i-1} sk=${aksk:i}
        local region_domain=`/opt/huawei/snas/script/LsHelper.py REGION_DOMAIN GET $ak $sk ${region_id}`
        if [ -z "${region_domain}" ]
        then
            value="${value},region_domain is null"
            LOG "INFO: region domain name are null" "$FUNCNAME" "${scriptName}"
        else
            #region域名解析
            value="${value},region_domain_name:${region_domain}"
            answer_sec=""
            dig_domain "$region_domain"
            value="${value},${answer_sec}"
        fi
    fi
}

######################################################################
#   FUNCTION   : main
#   DESCRIPTION: 主函数
#   INPUT      : 无
#   OUTPUT     : 无
######################################################################
function main()
{
    if [ -z "$obs_sod_properties_content" ]
    then
        value="${value},No obs_sod.properties file"
    else
        #HA节点判断
        is_node_active
        if [ $? -ne 0 ]
        then
            LOG "none-HA nodes do not need to inspect domainname" "INFO" "${scriptName}"
            value="${value},none-HA nodes do not need to inspect domainname"
            else
            #DNS域名解析
            dig_dns_domain
            if [ -z "$multiaz_ini_content" ]
            then
                value="${value},No multiaz.ini file"
                LOG "INFO: No multiaz.ini file" "$FUNCNAME" "${scriptName}"
            else
                #region/website域名解析
                dig_region_domain
            fi
        fi
    fi

    echo "${value}" | grep "^," >/dev/null 2>&1
    if [ $? -eq 0 ]
    then
        value="${value#?}"
    fi
    LOG "INFO: result=${res};value=${value};" "$FUNCNAME" "${scriptName}"
}

main

echo "${value}"
echo "Result:${res}"
