from psdk.platform.base import base_util
from psdk.platform.base.logger import log
from psdk.platform.util.product_util import compare_version, get_version_without_patch
import ast


def check_products(support_products, model, version, scene, tool, step):
    for support_tool in support_products:
        check_product = CheckProduct(support_tool)
        support_scenes = support_tool.get("scene_if")
        if support_scenes and not is_support_scene(support_scenes, scene, tool, step):
            continue
        if check_product.is_match(model, version):
            return True
    return False


def is_support_scene(support_scene, scene, tool, step):
    if scene in support_scene:
        return True
    if tool in support_scene:
        return True
    if "{}#{}".format(tool, step) in support_scene:
        return True
    return False


class CheckProduct(object):
    def __init__(self, support_tool):
        self.series = support_tool.get("series")
        self.model = support_tool.get("model")
        self.version = support_tool.get("version", "")
        self.start_version = support_tool.get("start_version", "")
        self.end_version = support_tool.get("end_version", "")
        self.black_model = support_tool.get("black_model", "")

    def _check_model(self, current_model):
        if self.model == "all" or self.black_model:
            models = base_util.get_product_model_by_series(self.series)
        else:
            models = self.get_modes()
        return current_model in models and current_model not in self.black_model

    def get_modes(self):
        try:
            return ast.literal_eval(str(self.model))
        except ValueError:
            log.error("parse model error!")
            return self.model

    def _check_version(self, current_version):
        if any(["V5_KP" in self.series and "kunpeng" not in str(current_version).lower(),
                "V5_KP" not in self.series and "kunpeng" in str(current_version).lower()]):
            return False
        if self.version == "all":
            return True
        if self.start_version and compare_version(current_version, self.start_version) < 0:
            return False
        if self.end_version and compare_version(current_version, self.end_version) > 0:
            return False
        if self.version and get_version_without_patch(current_version) not in self.version:
            return False
        return True

    def is_match(self, current_model, current_version):
        return self._check_model(current_model) and self._check_version(current_version)


