# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

import ast
import re

from psdk.platform.entity.execute_env import FruExecuteEnv


def is_selected_fan_in_disk_enclosure(self):
    if not isinstance(self.context.execute_env, FruExecuteEnv):
        return False
    if self.context.execute_env.tool_name != "fru_fan" or not self.context.execute_env.selected_fru:
        self.logger.info("not fru fan")
        return False
    selected_fan = ast.literal_eval(self.context.execute_env.selected_fru)
    parent_id = selected_fan[0].get("parentID", "").strip() if isinstance(selected_fan, list) else\
        selected_fan.get("parentID", "").strip()
    self.logger.info("fan parent id ={}".format(parent_id))
    return not re.match("[0-9][A-D]$", parent_id)
