# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.

import re


# 检查项执行完后，关闭cli链接
def self_exit(self, script_name):
    cli_connection = "CLI_CONNECTION"
    try:
        cli = self.dsl_obj.dsl_context.context.get_item(cli_connection + self.context.get_dev_node().ip + \
                                                        self.context.get_dev_node().sn)
        if cli and cli.isConnected():
            cli.close()

        self.logger.info(script_name + " exit success")
    except Exception as e:
        self.logger.error([script_name + " exit failed", e])


# 根据框类型跳转到目标框
def check_subrack_type(self, object_name, script_name):
    try:
        if 'CTE' in object_name:
            # 获取控制框号
            subrack_num_info = re.search(r'CTE\d', object_name).group()
            subrack_num = subrack_num_info[subrack_num_info.index("CTE") + 3]
            # 跳转至目标框节点，node_cfg为固定参数2
            self.dsl("exec_mini_system 'sshtoremoteExt %s'" % str(int(subrack_num) * 2))
            ret = self.dsl("exec_cli '%s'" % self.context.dev_node.password, need_log=False)
            # 增加调框失败判断
            if not ret:
                self.logger.info(script_name + " CLI connection failed. " + object_name)
                return False
            return True
        if 'DAE' in object_name:
            turn_ptr = object_name + ('.A')
            self.dsl("exec_mini_system 'sshtoipenclosure %s'" % turn_ptr)
            ret = self.dsl("exec_cli '%s'" % self.context.dev_node.password, need_log=False)
            # 增加调框失败判断
            if not ret:
                self.logger.info(script_name + " CLI connection failed. " + object_name)
                return False
            self.dsl("exec_cli 'minisystem'")
            return True
        else:
            return False
    except Exception as e:
        self.logger.error([script_name + " check_subrack_type failed", e])
        return False
