# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.platform.protocol.cli_common import get_system_version_without_ret

from psdk.platform.util.product_util import compare_patch_version


class CheckItem(BaseCheckItem):
    def execute(self):
        # 检查方法步骤1：使用dsl执行命令查询ISCSI启动器的信息
        enclosures = self.dsl("exec_cli  'show initiator initiator_type=iSCSI' | horizontal_parser")
        if not enclosures:
            return CheckStatus.PASS, ""
        iscsi_len = 0
        iscsi_offline_len = 0
        # 检查方法步骤2：查看以上回显中ISCSI启动器对象时候超过256个，并且存在离线的ISCSI启动器
        for iscsi_info in enclosures:
            iscsi_len = iscsi_len + 1
            if iscsi_info.get("Running Status") == 'Offline':
                iscsi_offline_len = iscsi_offline_len + 1
        if iscsi_len < 256:
            return CheckStatus.PASS, ""
        else:
            if iscsi_offline_len == 0:
                return CheckStatus.PASS, ""
            else:
                return CheckStatus.NOT_PASS, self.get_msg("check.not.pass")

