# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.dsl import fault_mode as ft


class CheckItem(BaseCheckItem):
    def execute(self):

        # 检查方法步骤1：使用dsl执行命令查询fs_migration信息
        storagepools_id_arr = self.dsl("exec_developer 'show storage_pool general |filterColumn include "
                                       "columnList=ID' | horizontal_parser | get_key('ID')")
        if not storagepools_id_arr:
            return CheckStatus.PASS, ""
        else:
            return CheckStatus.NOT_PASS, self.get_msg("check.not.pass")
