# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.

import re

from cbb.frame.cli import cliUtil
from cbb.frame.context import contextUtil
from psdk.dsl.adapter import dsl_adapter


def is_single_engine(engine_info):
    """
    是否单引擎
    """
    return len(engine_info) == 1


def is_kunpeng(product_version):
    """
    是否kunpeng
    """
    return " Kunpeng" in product_version


def is_nat_network(dsl, context):
    """
    是否nat组网场景
    """
    logger = context.get_logger()
    lang = context.get_lang()
    dev_ip = context.get_dev_node().ip

    ret = dsl("exec_cli 'show port general'")
    if dev_ip in ret:
        logger.info("[Pre_Check] is_management_ip_configed res: True! msg is:{}".format(ret))
        return False

    ret = dsl("exec_cli 'show system management_ip'")
    if dev_ip in ret:
        logger.info("[Pre_Check] is_management_ip_configed res: True! msg is:{}".format(ret))
        return False
    logger.error("[Pre_Check] is_management_ip_configed res: False!")
    return True


def is_ip_v6(ip_str):
    """
    用于区分是IP V4 还是 IP V6
    """
    return ":" in ip_str


def get_inner_ip(context, cli, ctrl_id):
    logger = context.get_logger()
    lang = context.get_lang()
    _, cli_ret, _ = cliUtil.sshToRemoteContr(cli, "sshtoremoteExt {}".format(ctrl_id),
                                             context.dev_node.password, lang)
    cliUtil.exitHeartbeatCli(cli, lang)
    cliUtil.enterCliModeFromSomeModel(cli, lang)
    pattern = re.compile(r"\d+\.\d+\.\d+\.\d+")
    matched_ip = re.findall(pattern, cli_ret)
    logger.info("[get_inner_ip] succ:{}".format(matched_ip))
    return matched_ip


def get_ctrl_name_ip_dict(cli, lang):
    """
    获取所有控制器的ip和控制器名称的对应关系
    :param cli: cli 连接
    :param lang: 语言
    :return: 控制器名称和IP列表，以及引擎和控制器名称列表
    """
    ctrl_name_ip_dict = {}
    engine_ctrl_dict = {}
    cmd = "show upgrade package"
    flag, cli_ret, error_msg = cliUtil.execCmdInCliMode(cli, cmd, True, lang)
    if not flag:
        return False, ctrl_name_ip_dict, engine_ctrl_dict

    hot_patch_begin_index = cli_ret.find("HotPatch Version")
    software_begin_index = cli_ret.find("Software Version")
    if software_begin_index == -1 or hot_patch_begin_index == -1:
        return False, ctrl_name_ip_dict, engine_ctrl_dict
    software_list = cliUtil.getHorizontalNostandardCliRet(
        cli_ret[software_begin_index:hot_patch_begin_index])
    for software in software_list:
        controller_ip = software.get("IP")
        controller_name = software.get("Name")
        temp_list = engine_ctrl_dict.get(controller_name[0], [])
        temp_list.append(controller_name)
        engine_ctrl_dict[controller_name[0]] = temp_list
        ctrl_name_ip_dict[controller_name] = controller_ip

    return True, ctrl_name_ip_dict, engine_ctrl_dict
