# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.platform.protocol.cli_common import get_system_version_without_ret
from psdk.platform.util.product_util import compare_version, compare_patch_version


class CheckItem(BaseCheckItem):
    def check_1822v120_exist(self, slot_id):
        cmd = "exec_cli 'show interface_module interface_module_id={}'".format(slot_id)
        info = self.dsl(cmd)
        return "and later" in info


    def check_be_card_exist(self):
        # 检查是否存在roce后端卡
        cards = self.dsl("exec_cli 'show interface_module' | horizontal_parser")
        if not cards:
            return False

        for card in cards:
            # 获取卡类型
            model = card.get("Model")
            # 存在RoCE后端卡
            if "2 ports BE 100 Gbit/s RDMA I/O module" in model:
                slot_id = card.get("ID")
                if self.check_1822v120_exist(slot_id):
                    return True
        return False

    def execute(self):
        # 步骤1执行命令show upgrade package，查询当前阵列产品软件版本；
        flag, software_version, hot_patch_version = \
            get_system_version_without_ret(self.dsl("exec_cli 'show upgrade package'"))
        if compare_version(software_version, "6.1.6") == 0 and compare_patch_version(hot_patch_version, "SPH10") < 0:
            if self.check_be_card_exist():
                return CheckStatus.WARNING, ""
        if compare_version(software_version, "6.1.5") == 0 and compare_patch_version(hot_patch_version, "SPH30") < 0:
            if self.check_be_card_exist():
                return CheckStatus.WARNING, ""

        return CheckStatus.PASS, ""
