# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.platform.protocol.cli_common import get_system_version_without_ret


class CheckItem(BaseCheckItem):
    def execute(self):
        # 检查是否是从V5R7C60SPC100升级
        flag, software_version, hot_patch_version = \
            get_system_version_without_ret(self.dsl("exec_cli 'show upgrade package'"))
        if software_version != "V500R007C60SPC100":
            #检查是否升级到C61
            if self.get_upgrade_target_version() != "V500R007C61" and \
                    self.get_upgrade_target_version() != "V300R006C61":
                return CheckStatus.PASS, ""
        #获取所有控制器id
        ctrl_ids = self.dsl("exec_developer  'show controller general |filterColumn include columnList=Controller' | "
                            "vertical_parser | get_key('Controller')")
        for ctrl_id in ctrl_ids:
            # 检查是否有cifs连接
            results = self.dsl("exec_developer 'show cifs connection controller={}' | vertical_parser".format(ctrl_id))
            if results:
                return CheckStatus.NOT_PASS, self.get_msg("check.not.pass")
        return CheckStatus.PASS, ""

