# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

import time
from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.platform.util.base_util import get_common_msg


class CheckItem(BaseCheckItem):
    def execute(self):
        support_fs = self.dsl("exec_diagnose 'fs' | vertical_parser")
        if "Error" in support_fs[0].keys():
            return CheckStatus.PASS, ""
        # 检查方法步骤4：执行命令"sys.sh showvnode"查询当前存储设备上vnode数量
        all_vnode_info = self.dsl("exec_mini_system 'sys.sh showvnode' | horizontal_parser")
        if not self.is_supper_admin():
            return CheckStatus.NOT_CHECK, get_common_msg(self.lang, "loginUser.name.level.must.be.super.admin")
        risk_vnode = self.dsl("exec_on_all {}", self.check_vnode, all_vnode_info)
        vnode_id_list = []
        for _, node_value in risk_vnode.items():
            for node in node_value:
                vnode_id_list.append(node)
        if not vnode_id_list:
            return CheckStatus.PASS, ""
        return CheckStatus.NOT_PASS, self.get_msg("check.not.pass", ",".join(vnode_id_list))

    def check_vnode(self, all_vnode_info):
        vnode_id = []
        risk_vnode = []
        for vnode in all_vnode_info:
            # 如果存在curConsumer == maxConsumer的vnode，等待3秒再检查一次
            if self.check_adel_task(vnode.get("VnodeId")):
                vnode_id.append(vnode.get("VnodeId"))
        if len(vnode_id) == 0:
            return vnode_id
        time.sleep(3)
        for vnode in vnode_id:
            if self.check_adel_task(vnode):
                risk_vnode.append(vnode)
        return risk_vnode

    def check_adel_task(self, vnode):
        info = self.dsl("exec_diagnose 'fs bgr adelshow -vnode {}'".format(vnode))
        if "Vnode(ID {}) not exist.".format(vnode) in info:
            return False
        vnode_info = self.dsl("exec_diagnose 'fs bgr adelshow -vnode {}' | vertical_parser".format(vnode))
        cur_consumer = vnode_info[0].get("curConsumer")
        max_consumer = vnode_info[0].get("maxConsumer")
        if cur_consumer == max_consumer:
            return True
        return False

