# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus


class CheckItem(BaseCheckItem):
    def execute(self):
        # 检查邮箱通知告警是否配置
        if self.check_email_config():
            return CheckStatus.PASS, ""

        # 检查snmp通知告警是否配置
        if self.check_snmp_config():
            return CheckStatus.PASS, ""

        # 检查syslog通知告警是否配置
        if self.check_syslog_config():
            return CheckStatus.PASS, ""

        # 都没有配置，检查不通过
        return CheckStatus.WARNING, self.get_msg("check.not.pass")

    def check_email_config(self):
        """
        检查是否配置邮箱监控告警
        :return:True-已配置，False-未配置
        """
        # 检查方法：使用dsl执行命令show notification email_extend检查是否配置邮箱上报告警
        results = self.dsl("exec_cli 'show notification email_extend' | vertical_parser")
        return results and results[0].get("Send Enable") != "No"

    def check_snmp_config(self):
        """
        检查是否配置SNMP监控告警
        :return:True-已配置，False-未配置
        """
        # 检查方法：使用dsl执行命令show notification trap检查是否配置snmp上报告警
        results = self.dsl("exec_cli 'show notification trap'")
        return 'Command executed successfully' not in results

    def check_syslog_config(self):
        """
        检查是否配置syslog监控告警
        :return:True-已配置，False-未配置
        """
        # 检查方法：使用dsl执行命令show notification syslog检查是否配置syslog监控告警
        results = self.dsl("exec_cli 'show notification syslog' | vertical_parser")
        return results and results[0].get("Enabled") != "No"
