# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.


from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.platform.protocol.cli_common import get_system_version_without_ret


class CheckItem(BaseCheckItem):
    def execute(self):
        # 获取版本信息，满足指定补丁版本
        if check_atime_software_version(self):
            return CheckStatus.PASS, ""
        # 查找文件系统是否开启Atime开关
        atime_list = self.dsl("exec_cli  'show file_system general "
                            "|filterColumn include columnList=Atime\sEnabled,ID'| horizontal_parser")
        if not atime_list:
            return CheckStatus.PASS, ""
        err_msg_list = ""
        error_atime_list = check_atime_status(atime_list)
        if error_atime_list:
            err_msg_list = self.get_msg("check.not.pass")
            err_msg_list += "\nfile system id:"
            for item in error_atime_list:
                err_msg_list += " " + item

        if err_msg_list:
            return CheckStatus.NOT_PASS, err_msg_list
        return CheckStatus.PASS, ""


def check_atime_software_version(self):
    # 获取版本信息，满足指定补丁版本
    flag, software_version, hot_patch_version = \
        get_system_version_without_ret(self.dsl("exec_cli 'show upgrade package'"))
    if software_version == "V300R006C50SPC100" and hot_patch_version[-3:] >= "139":
        return 1
    if software_version == "V500R007C30SPC100" and hot_patch_version[-3:] >= "139":
        return 1
    if software_version == "V500R007C60SPC100" and hot_patch_version[-3:] >= "111":
        return 1
    if software_version == "V500R007C60SPC300" and hot_patch_version[-3:] >= "328":
        return 1
    if software_version == "V500R007C61" and hot_patch_version[-3:] >= "050":
        return 1
    if software_version == "V300R006C61" and hot_patch_version[-3:] >= "050":
        return 1
    if software_version == "V500R007C71SPC100" and hot_patch_version[-3:] >= "130":
        return 1
    if software_version == "V500R007C73SPC100" and hot_patch_version[-3:] >= "110":
        return 1
    return 0


def check_atime_status(atime_list):
    """
    存在文件系统的“Atime Enabled”字段值为“Yes”，
    """
    error_atime_list = [
        file_system.get("ID")
        for file_system in atime_list
        if (file_system.get("Atime Enabled") == "Yes")
    ]
    return error_atime_list