# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2022. All rights reserved.
from psdk.checkitem.common.audit_log_risk_devices import is_in_audit_log_risk_devices
from psdk.checkitem.common.system_disk_life import CheckSystemDiskLifeItem
from psdk.dsl.dsl_common import get_version_info, get_engine_height
from psdk.platform.entity.check_status import CheckStatus
from psdk.platform.util.product_util import compare_patch_version
from psdk.platform.util.base_util import get_common_msg


class SmartInfo:
    def __init__(self, life, poh):
        self.life = life
        self.poh = poh


class CheckItem(CheckSystemDiskLifeItem):
    def __init__(self, context):
        super(CheckItem, self).__init__(context)
        self.current_node_id = "-1"
        self.engine_height = 0
        self.ctrl_in_scope = False

    def execute(self):
        if not self.is_supper_admin():
            return CheckStatus.NOT_CHECK, get_common_msg(self.lang, "loginUser.name.level.must.be.super.admin")

        self.engine_height = get_engine_height(self.dsl, self.context)
        results = self.dsl("exec_on_all {}", self.get_drive_life)
        for result in results.values():
            if int(result) != 0:
                return CheckStatus.NOT_PASS, self.get_msg("check.not.pass")

        if self.ctrl_in_scope:
            version_info = get_version_info(self.dsl)
            cur_version = version_info.get("base_version").get("Current Version")
            patch_version = version_info.get("patch_version").get("Current Version")
            if (cur_version == "6.1.0") and (compare_patch_version(patch_version, "SPH9") < 0):
                # 命中audit_log问题批次版本则返回不通过
                return CheckStatus.NOT_PASS, self.get_msg("version.not.pass", cur_version, patch_version)
        return CheckStatus.PASS, ""

    def _is_in_check_scope(self):
        self.current_node_id = self._get_current_node_id()
        if is_in_audit_log_risk_devices(self.dsl, self.current_node_id, self.engine_height):
            self.ctrl_in_scope = True
            return True
        return False

    # 不再检查磨损度，方法默认通过.之前是因为要检查风险设备,当前风险设备已完成变更,仅检查补丁版本。
    def _judge_drive_smart_exception(self, life, poh, flag):
        return True

    def _get_current_node_id(self):
        dev_infos = self.dsl("exec_diagnose 'sys showcls' | vertical_parser")
        if dev_infos:
            dev_info = dev_infos[0]
            return dev_info.get("local node id")
        return "-1"
