# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus


class CheckItem(BaseCheckItem):
    def execute(self):
        domains = self.dsl("exec_cli 'show disk_domain general |filterColumn include columnList=ID' "
                           "| horizontal_parser")
        if not domains:
            self.logger.info("no domains. check pass")
            return CheckStatus.PASS, ""
        flags = self.dsl("exec_diagnose 'pmgr showIsLeakCapOverThreshold' | horizontal_parser")
        flag = [item.get("leak flag").lower() for item in flags]
        # 标记为1代表容量泄露达到阈值
        if "1" in flag:
            return CheckStatus.NOT_PASS, self.get_msg("check.not.pass")
        return CheckStatus.PASS, ""
