# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

import re

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.platform.util.base_util import get_common_msg
from psdk.platform.util.product_util import is_support_cross_engine_ssh



class CheckItem(BaseCheckItem):
    def execute(self):
        # 检查方法步骤4：使用dsl执行命令查询ccdb数据备份信息
        backup_infos = self.query_backup_infos()
        if not backup_infos:
            return CheckStatus.PASS, ""

        for backup_info in backup_infos:
            db_name = backup_info.get("db name")
            if db_name != "ccdb_metadata.db":
                continue
            backup_path = backup_info.get("backup path")
            if backup_path is None:
                continue
            backup_uuid_list = re.findall(r"(?<=_)\d+(?=/ccdb_metadata\.db)", backup_path)
            if len(backup_uuid_list) != 1:
                continue
            backup_uuid = int(backup_uuid_list[0])

            # 检查方法步骤5：使用dsl执行命令查询db的uuid
            uuid_strs = self.dsl("exec_on_all {}", self.query_uuid_info)

            # 根据检查标准判断
            for _, uuid_str in uuid_strs.items():
                if uuid_str is None:
                    continue
                uuid = int(uuid_str)
                if backup_uuid != uuid and backup_uuid != 0:
                    return CheckStatus.NOT_PASS, self.get_msg("check.not.pass")
                return CheckStatus.PASS, ""
        return CheckStatus.PASS, ""

    def query_backup_infos(self):
        results = self.dsl("exec_mini_system 'ccdb.sh -c showbackupinfo' | horizontal_parser",
                           end_str_list=["minisystem>", "minisystem> "])
        return results

    def query_uuid_info(self):
        uuid_infos = self.dsl("exec_mini_system 'ccdb.sh -c showdb ccdb_metadata.db' "
                              "| splitlines | regex '\s*db uuid:\s*(?P<uuid>\d+)'",
                              end_str_list=["minisystem>", "minisystem> "])
        if len(uuid_infos) != 1:
            return None
        db_uuid_str = uuid_infos[0].get("uuid")
        return db_uuid_str
