# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2022. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.dsl.dsl_common import get_version_info
from psdk.platform.entity.check_status import CheckStatus
from psdk.platform.util.base_util import get_common_msg
from psdk.platform.util.product_util import compare_patch_version
from psdk.dsl import fault_mode as ft

CHECK_612_BASE_VERSION = "6.1.2"
NOT_CHECK_612_FLAG_PATCH_VERSION = "SPH12"
CHECK_613_BASE_VERSION = "6.1.3"
NOT_CHECK_613_FLAG_PATCH_VERSION = "SPH3"
WS_SHOW_37_RESULT_INDEX = 0
H_FLOWRATE_RESULTS_INDEX = 1
DDP_LICENSE_NAME = ['SmartCompression Software License Premium', 'SmartCompression Software License Enhanced',
                    'SmartCompression Software License Exclusive', 'SmartCompression Software License General',
                    'SmartCompression Software License Advanced', 'SmartCompression Software License Standard']


class CheckItem(BaseCheckItem):

    @staticmethod
    def check_license_name(item):
        for license_name in DDP_LICENSE_NAME:
            if license_name in item.get('Feature Name'):
                return True
        return False

    def execute(self):
        # 步骤1 以admin用户登录设备，并查看产品型号、版本和补丁版本；
        # 若步骤1中版本号为Dorado V6 6.1.2 SPH12之前的版本(不包含SPH12)或者Dorado V6 6.1.3 SPH1版本则继续检查，其余版本检查通过
        if not self.is_supper_admin():
            return CheckStatus.NOT_CHECK, get_common_msg(self.lang, "loginUser.name.level.must.be.super.admin")
        version_info = get_version_info(self.dsl)
        cur_version = version_info.get("base_version").get("Current Version")
        patch_version = version_info.get("patch_version").get("Current Version")
        if ((cur_version == CHECK_612_BASE_VERSION) and (
                compare_patch_version(patch_version, NOT_CHECK_612_FLAG_PATCH_VERSION) >= 0)) or (
                (cur_version == CHECK_613_BASE_VERSION) and (
                compare_patch_version(patch_version, NOT_CHECK_613_FLAG_PATCH_VERSION) >= 0)):
            return CheckStatus.PASS, ""
        if not self.has_ddp_license():
            return CheckStatus.PASS, ""
        results = self.dsl("exec_on_all {}", self.check_single_dedup_ws_quota)
        if 0 in results.values():
            return CheckStatus.NOT_PASS, self.get_err_msg("check.not.pass", "item.suggestion")
        return CheckStatus.PASS, ""

    def get_disk_domain_info(self):
        disk_domain_results = self.dsl("exec_cli 'show disk_domain general' |horizontal_parser",
                                       return_if={ft.FindStr("Error:"): 'not_check'})
        disk_domain_list = []
        for dd_info in disk_domain_results:
            disk_domain_list.append("op_dpId_" + dd_info.get("ID"))
        return disk_domain_list

    def compare_history_period_flowrate(self):
        h_flowrate_results = self.dsl("exec_diagnose 'qos show ws_inner_obj 37 21' | vertical_parser",
                                      return_if={ft.FindStr("Error:"): 'not_check'})
        ws_his_rate_quota = str(h_flowrate_results[H_FLOWRATE_RESULTS_INDEX].get('Ws His Rate Quota[0]')).split()
        ws_his_rate_perf = str(h_flowrate_results[H_FLOWRATE_RESULTS_INDEX].get('Ws His Rate Perf[0]')).split()
        compare_result = []
        for index, _ in enumerate(ws_his_rate_perf):
            if int(ws_his_rate_perf[index]) < int(ws_his_rate_quota[index]):
                compare_result.append(0)
            else:
                compare_result.append(1)
        return compare_result

    def has_ddp_license(self):
        show_license_results = self.dsl("exec_cli 'show license' | vertical_parser",
                                        return_if={ft.FindStr("Error:"): "not_check"})
        check_license_result = []
        if (len(show_license_results) == 0) or (show_license_results == 'not_check'):
            return True
        for item in show_license_results:
            if 'Effective Capacity' == item.get('Feature Name') or self.check_license_name(item):
                return True
        return False


    def check_single_dedup_ws_quota(self):
        # change user_mode current_mode user_mode=developer，进入开发者模式;
        # 进入debug模式,执行命令：db show db all，查看重删算法版本;db回显中NAME字段存在STASH关键字，则检查通过，否则继续检查；
        disk_domain_list = self.get_disk_domain_info()
        if len(disk_domain_list) == 0:
            return 1
        slashdb_lines = []
        show_db_results = self.dsl("exec_diagnose 'db show db all' |splitlines", end_str_list=["diagnose>"],
                                   return_if={ft.FindStr("Error:"): 'not_check'})
        if len(show_db_results) == 0:
            return 1
        for line in show_db_results:
            if "STASH" in line:
                slashdb_lines.append(line)
        match_result = []
        for disk_domain_info in disk_domain_list:
            if str(disk_domain_info) in str(slashdb_lines):
                match_result.append(1)
            else:
                match_result.append(0)
        if 0 not in match_result:
            return 1
        else:
            ws_show_37 = self.dsl("exec_diagnose 'ws show 37' | vertical_parser",
                                  return_if={ft.FindStr("Error:"): "not_check"})
            if ws_show_37 == "not_check":
                return 1
            if len(ws_show_37) == 0:
                return 1
            if int(ws_show_37[WS_SHOW_37_RESULT_INDEX].get("node flowrate quota")) < int(
                    ws_show_37[WS_SHOW_37_RESULT_INDEX].get("node max flowrate")):
                # 在原有条件基础上，增加历史周期实际流量和Quota的对比，若12个周期内所有的实际流量均小于Quota 才认为有问题(此条件也是Qos判断Quota是否可以上调的条件)
                compare_result = self.compare_history_period_flowrate()
                if 1 not in compare_result:
                    return 0
        return 1
