# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.dsl.dsl_common import get_version_info
from psdk.platform.util.product_util import compare_patch_version


class CheckItem(BaseCheckItem):
    def execute(self):
        # 检查方法步骤1/2：使用dsl执行命令查询版本信息
        version_info = get_version_info(self.dsl)
        cur_version = version_info.get("base_version").get("Current Version")
        patch_version = version_info.get("patch_version").get("Current Version")

        if (cur_version == "6.0.1") and (compare_patch_version(patch_version, "SPH12") >= 0):
            return CheckStatus.PASS, ""

        # 检查方法步骤3：show event |filterRow column=ID predict=equal_to value=0x200000D80007，查看删除存储池的记录
        event_info = self.dsl("exec_cli 'show event |filterRow column=ID predict=equal_to value=0x200000D80007'")
        if 'No matching records' in event_info:
            return CheckStatus.PASS, ""
        return CheckStatus.NOT_PASS, self.get_msg("check.not.pass")
