# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.platform.util.product_util import compare_patch_version
from psdk.dsl.dsl_common import get_version_info


class CheckItem(BaseCheckItem):
    def execute(self):
        # 步骤1-3 获取基本信息
        version_info = get_version_info(self.dsl)
        patch_version = version_info.get("patch_version").get("Current Version")
        version = version_info.get("base_version").get("Current Version")

        # 6.1.3安装了SPH10及以后补丁，通过
        if version == "6.1.3" and \
                compare_patch_version(patch_version, "SPH10") >= 0:
            return CheckStatus.PASS, ""

        # 步骤4-5  在minisystem下键入命令ls -l /startup_disk/image/pkg_cur/unroot_flag 查看是否存在Flag文件
        unroot_flag_files = self.dsl("exec_on_all {}", self.query_flag_file)
        for _, flag in unroot_flag_files.items():
            if not flag:
                return CheckStatus.NOT_PASS, self.get_msg("check.not.pass")
        return CheckStatus.PASS, ""

    def query_flag_file(self):
        unroot_flag_list = self.dsl("exec_mini_system 'ls -l /startup_disk/image/pkg_cur/unroot_flag'")
        if "No such file or directory" in unroot_flag_list:
            return False
        return True
