# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.platform.util.product_util import compare_patch_version
from psdk.dsl.dsl_common import get_version_info
from psdk.dsl import fault_mode as ft


class CheckItem(BaseCheckItem):
    def execute(self):
        # 获取基本信息
        version_info = get_version_info(self.dsl)
        patch_version = version_info.get("patch_version").get("Current Version")
        version = version_info.get("base_version").get("Current Version")

        # 检查补丁版本 ，oceanprotect暂不检查
        # 6.1.3
        if version.startswith("6.1.3") and compare_patch_version(patch_version, "SPH10") >= 0:
            return CheckStatus.PASS, ""

        # 6.1.5
        if version.startswith("6.1.5") and compare_patch_version(patch_version, "SPH8") >= 0:
            return CheckStatus.PASS, ""

        # 检查方法
        anti_virus = self.dsl("exec_cli 'show antivirus on_demand_task' | horizontal_parser",
                              return_if={ft.FindStr("Error:"): "check_not_pass"})

        if anti_virus == "check_not_pass":
            return CheckStatus.NOT_PASS, self.get_msg("check.not.pass")

        if len(anti_virus) != 0:
            return CheckStatus.NOT_PASS, self.get_msg("check.not.pass")

        # 提供命令打印，查看FSIO泄露数
        page_info = self.dsl("exec_diagnose 'dpumm_shm show usage page'",
                             return_if={ft.FindStr("Error:"): "check_not_pass"})

        # 从事件里面看是否有 创建扫描任务
        event_info = self.dsl("exec_cli 'show event |filterRow column=ID predict=equal_to value=0x200F011D0077 "
                              "logicOp=or column=ID predict=equal_to value=0x200F011D008C'")

        if 'No matching records' in event_info:
            return CheckStatus.PASS, ""
        else:
            return CheckStatus.NOT_PASS, self.get_msg("check.not.pass")

