# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.platform.util.product_util import compare_patch_version
from psdk.dsl.dsl_common import get_version_info
from psdk.dsl import fault_mode as ft


class CheckItem(BaseCheckItem):

    @staticmethod
    def check_notify_enable(self, version):
        vstore_list = self.dsl("exec_cli 'show vstore |filterColumn include columnList=ID' | horizontal_parser")
        for vstore_info in vstore_list:
            self.dsl("exec_cli 'change vstore view id={}'", vstore_info.get("ID"))
            notify_enable = self.dsl("exec_cli 'show service cifs |filterColumn include"
                                     " columnList=Notify\\sEnabled' | vertical_parser")
            self.dsl("exec_cli 'exit'")
            if notify_enable[0].get("Notify Enabled") == "No":
                return CheckStatus.WARNING, self.get_msg("check.warning", version)
        return CheckStatus.PASS, ""

    def execute(self):
        version_info = get_version_info(self.dsl)
        patch_version = version_info.get("patch_version").get("Current Version")
        display_version = self.dsl("exec_cli 'show system general' | vertical_parser")[0].get("Product Version")
        if compare_patch_version(patch_version, "SPH23") < 0:
            return CheckStatus.PASS, ""

        if compare_patch_version(patch_version, "SPH39") >= 0:
            return self.check_notify_enable(self, display_version)

        fs_exist = self.dsl("exec_cli 'show file_system general'| horizontal_parser",
                            return_if={ft.CmdNoSupport: "not_support"})
        if fs_exist == "not_support" or not fs_exist:
            return CheckStatus.PASS, ""
        return CheckStatus.NOT_PASS, self.get_msg("check.not.pass", display_version)


