# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.platform.util.product_util import compare_patch_version
from psdk.dsl.dsl_common import get_version_info
from psdk.dsl import fault_mode as ft


class CheckItem(BaseCheckItem):

    def execute(self):
        vaai_switch = self.dsl("exec_cli 'show file_system general |filterRow column=VAAI\\sSwitch predict=match "
                               "value=On|filterColumn include columnList=ID,VAAI\\sSwitch'| horizontal_parser",
                               return_if={ft.CmdNoSupport: "not_support"})
        if vaai_switch == "not_support" or not vaai_switch:
            return CheckStatus.PASS, ""

        version_info = get_version_info(self.dsl)
        patch_version = version_info.get("patch_version").get("Current Version")
        if compare_patch_version(patch_version, "SPH12") < 0:
            return CheckStatus.NOT_PASS, self.get_msg("check.not.pass")

        return CheckStatus.PASS, ""

