# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.
import time
import re
from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus


class CheckItem(BaseCheckItem):
    def __init__(self, context):
        super(CheckItem, self).__init__(context)
        self.need_check_map = {
            "VOLS_FCOPY_READ_GET_HASHREC": True,
            "VOLS_FCOPY_PREWRITE_COPY_GET_HASHREC": True,
            "VOLS_VAAI_ADD_TO_BGR ": True,
            "VOLS_SENDTODST_GET_HASH_RECORD": True,
            "VOLS_COUNTER_GET_HASH_RECORD": True
        }
        self.check_count = 5
        self.retry_count = 5

    def execute(self):
        # 检查方法步骤4：20s内，每秒调用一次，使用dsl执行命令查询count点的信息
        results = self.dsl("exec_on_all {}", self.is_fullcopy_normal_one_controller)
        for result in results.values():
            if not result:
                return CheckStatus.NOT_PASS, self.get_err_msg("check.not.pass", "item.suggestion",
                                                              self.context.dev_node.version)
        return CheckStatus.PASS, ""

    def is_fullcopy_normal_one_controller(self):
        start_time = time.time()
        while time.time() - start_time <= 20:
            result_lines = self.dsl("exec_diagnose 'vol showallcount all on'")
            if not result_lines:
                if self.retry_count > 0:
                    self.retry_count -= 1
                    time.sleep(1)
                    continue
                else:
                    return False
            for key, val in self.need_check_map.items():
                if val and key not in result_lines:
                    self.need_check_map[key] = False
                    self.check_count -= 1
            if self.is_fullcopy_resource_normal(result_lines):
                return True
            time.sleep(1)
        return False

    def update_check_map(self, line, key):
        strs = re.split(" +", line)
        if len(strs) > 5 and strs[4] == "0":
            if self.need_check_map[key]:
                self.need_check_map[key] = False
                self.check_count -= 1
                return True
        return False
        
    def is_fullcopy_resource_normal(self, result_lines):
        """
        检查标准1：是否含有正在执行的后台fullcopy任务
        """
        is_normal = True
        lines = result_lines.split("\n")
        for line in lines:
            if self.check_count == 0:
                return is_normal
            for key, val in self.need_check_map.items():
                if val and key in line:
                    is_normal = is_normal and self.update_check_map(line, key)
        return is_normal


