# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.dsl import fault_mode as ft
from psdk.platform.util.base_util import get_common_msg

HDD_DISK_TYPES = ('SAS', 'NearLine SAS', 'SAS SED', 'NearLine SAS SED')

# 以天数为基数
FIVE_YEAR = 5 * 365
THREE_YEAR = 3 * 365


class CheckItem(BaseCheckItem):
    def execute(self):
        disk_run_time_infos = \
            self.dsl("exec_cli 'show disk general |filterColumn include columnList=ID,Type,Run\sTime(Day)'"
                     " | horizontal_parser", return_if={ft.CmdNoSupport: "not_check", ft.FindStr("Error"): "not_check"})
        if disk_run_time_infos == 'not_check':
            return CheckStatus.NOT_CHECK, get_common_msg(self.lang, "query.result.abnormal")
        run_time_between_three_and_five_years_flag = False
        for disk_run_time_info in disk_run_time_infos:
            if disk_run_time_info.get('Type') not in HDD_DISK_TYPES:
                continue
            disk_run_time = self._get_disk_run_time(disk_run_time_info.get('Run Time(Day)'))
            if disk_run_time > FIVE_YEAR:
                return CheckStatus.NOT_PASS, self.get_msg("check.not.pass")
            if disk_run_time > THREE_YEAR:
                # 使用硬盘年限为3-5年时，设置标识，继续判断是否仍然存在超过5年的
                run_time_between_three_and_five_years_flag = True
        if run_time_between_three_and_five_years_flag:
            return CheckStatus.WARNING, self.get_msg("check.recommended.optimization")
        return CheckStatus.PASS, ""

    def _get_disk_run_time(self, disk_run_time):
        try:
            return int(disk_run_time)
        except (ValueError, TypeError) as e:
            return 0
