# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.platform.util.product_util import compare_patch_version
from psdk.platform.util.base_util import get_common_msg
from psdk.dsl.dsl_common import get_version_info
from psdk.dsl.dsl_common import get_engine_height
from psdk.platform.util.product_util import get_ctrl_id_by_node_id
from psdk.dsl import fault_mode as ft

# IPV6邻居的最大数量
MAX_IPV6_NEIGH_NUM = 900
CHECK_IPV6_NEIGH_PASS_VERSION = {'V500R007C60SPC300': 'SPH322', 'V500R007C10': 'SPH38',
                                 'V500R007C30SPC100': 'SPH135', 'V500R007C61': 'SPH30',
                                 'V300R006C61': 'SPH30', 'V300R006C20': 'SPH38', 'V300R006C50SPC100': 'SPH135'}


class CheckItem(BaseCheckItem):
    def execute(self):
        version_info = get_version_info(self.dsl)
        patch_version = version_info.get("patch_version").get("Current Version")
        version = version_info.get("base_version").get("Current Version")
        for soft, patch in CHECK_IPV6_NEIGH_PASS_VERSION.items():
            if version == soft and \
                    compare_patch_version(patch_version, patch) >= 0:
                return CheckStatus.PASS, ""

        if self.context.dev_node.is_svp_dev_and_outside_svp:
            return CheckStatus.NOT_CHECK, get_common_msg(self.lang, "chunk.check.connect.to.controller.failed")

        self.logger.info("context is : {}".format(self.context.dev_node.user_name))
        if not self.is_supper_admin():
            return CheckStatus.NOT_CHECK, get_common_msg(self.lang, "loginUser.name.level.must.be.super.admin")

        results = self.dsl("exec_on_all {}", self.check_ipv6_neigh_num)
        abnormal_ctrls = []
        engine_height = get_engine_height(self.dsl, self.context)
        for node_id, count in results.items():
            if count > MAX_IPV6_NEIGH_NUM:
                ctrl_id = get_ctrl_id_by_node_id(node_id, engine_height)
                msg = self.get_msg("check.not.pass", str(count))
                abnormal_ctrls.append((ctrl_id, msg))
        err_msg = []
        for abnormal_ctrl in abnormal_ctrls:
            err_msg.append(self.get_msg("ctrl.id.not.pass", abnormal_ctrl[0], abnormal_ctrl[1]))

        if err_msg:
            return CheckStatus.NOT_PASS, "\n".join(err_msg)
        return CheckStatus.PASS, ""

    def check_ipv6_neigh_num(self):
        neighs = \
            self.dsl("exec_mini_system 'ip -6 neigh'",
                     return_if={ft.FindStr("Error:"): "not_check"})
        if neighs == "not_check":
            return 0

        result = neighs.splitlines()
        num = len(result)
        if num > 2:
            num = num - 2
        return num
