# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
import re

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.platform.util.product_util import compare_patch_version, compare_version
from psdk.dsl.dsl_common import get_version_info
from psdk.platform.util.base_util import get_common_msg


class CheckItem(BaseCheckItem):
    port_id_list = []

    def execute(self):
        # 检查方法步骤1：以admin用户登录设备
        # 若不是超级管理员用户，则检查结果为检查未完成
        if not self.is_supper_admin():
            return CheckStatus.NOT_CHECK, get_common_msg(self.lang, "loginUser.name.level.must.be.super.admin")
        # 若步骤2中软件版本和热补丁版本满足下列关系，则检查通过，否则继续检查
        # 6.1.5：SPH12或其之后补丁；6.1.3：SPH30或其之后补丁
        # 由于设置执行环境为615和613，因此需要检查补丁版本大于或等于SPH12且版本为615，以及补丁版本大于或等于SPH30且版本为613，若执行条件变更，需要同步修改补丁判断条件
        version_info = get_version_info(self.dsl)
        # 获取产品版本和补丁版本,获取不到产品版本和补丁版本返回不通过
        base_version = version_info.get("base_version").get("Current Version")
        sph_version = version_info.get("patch_version").get("Current Version")
        if (compare_version(base_version, "6.1.3") == 0) and (compare_patch_version(sph_version, "SPH30") >= 0):
            return CheckStatus.PASS, ""
        if (compare_version(base_version, "6.1.5") == 0) and (compare_patch_version(sph_version, "SPH12") >= 0):
            return CheckStatus.PASS, ""
        self.port_id_list = []
        self.check_iscsi_ini_over_dtoe()
        # 检查方法步骤6：若步骤5中检查通过，则检查通过，否则检查不通过
        if not self.port_id_list:
            return CheckStatus.PASS, ""
        # 数组去重
        port_id_list_new = list(set(self.port_id_list))
        if not sph_version.startswith("SPH"):
            sph_version = ""
        err = self.get_msg("check.not.pass", base_version + sph_version, ",".join(port_id_list_new))
        return CheckStatus.NOT_PASS, err

    def check_iscsi_ini_over_dtoe(self):
        # 检查方法步骤3：执行命令 show remote_device elink link_type=iSCSI |filterColumn include columnList=Local\sIP，查询iSCSI启动器IP
        link = str(self.dsl("exec_cli 'show remote_device elink link_type=iSCSI "
                            "|filterColumn include columnList=Local\\sIP'"))
        # 取第三行及之后的ip
        link_list = [line for line in link.splitlines() if line.strip()]
        ip_list = link_list[2:]
        if not ip_list:
            return
        # 检查方法步骤4：执行命令 show logical_port general，在回显中找出步骤3 iSCSI启动器IP所对应的端口号
        nic = str(self.dsl("exec_developer 'show logical_port general'"))
        for ip in ip_list:
            ip = ip.strip()
            pattern = re.compile(r'.*?' + str(ip) + '.*?ETH\s+(.*?)\s+.*?iSCSI')
            eth_port_id = pattern.findall(nic)
            for port_id in eth_port_id:
                # 检查方法步骤5：执行命令 show port eth_toe_switch eth_port_id=步骤4中端口号，查询端口的DTOE能力是否为Yes
                dtoe = str(self.dsl("exec_developer 'show port eth_toe_switch eth_port_id={}'" .format(port_id)))
                if dtoe.find("Yes") != -1:
                    self.port_id_list.append(port_id)
        return
