# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus


class CheckItem(BaseCheckItem):

    def execute(self):
        # 检查show kms key_backup是否报系统繁忙
        result = self.dsl("exec_cli 'show kms key_backup'")
        if 'The system is busy' in result:
            return CheckStatus.NOT_PASS, self.get_msg("check.not.pass")

        return CheckStatus.PASS, ""
