# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.dsl.dsl_common import get_version_info
from psdk.platform.entity.check_status import CheckStatus
from psdk.platform.util.product_util import compare_patch_version


class CheckItem(BaseCheckItem):
    def execute(self):
        if self.judge_patch_version():
            return CheckStatus.PASS, ""
        return CheckStatus.NOT_PASS, self.get_msg("item.suggestion")

    def judge_patch_version(self):
        version_info = get_version_info(self.dsl)
        patch_version = version_info.get("patch_version").get("Current Version")
        version = version_info.get("base_version").get("Current Version")

        if version == "6.1.6":
            if compare_patch_version(patch_version, "SPH2") < 0:
                return False
        return True