# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.dsl.dsl_common import get_version_info
from psdk.platform.entity.check_status import CheckStatus
from psdk.platform.util.product_util import compare_patch_version

VERSION_612 = "6.1.2"
VERSION_613 = "6.1.3"
DEST_PATCH_VERSION_612 = "SPH18"
DEST_PATCH_VERSION_613 = "SPH5"


class CheckItem(BaseCheckItem):
    @staticmethod
    def has_sync_workmode(fs_hyper_metro_domain_info):
        """
        检查标准：是否含有双活同步模式的NAS
        """
        for domain in fs_hyper_metro_domain_info:
            if domain.get("Work Mode") == "Synchronous":
                return True
        return False

    def execute(self):
        # 查询系统软件版本和热补丁版本信息
        version_info = get_version_info(self.dsl)
        patch_version = version_info.get("patch_version").get("Current Version")
        version = version_info.get("base_version").get("Current Version")

        # 6.1.2安装了SPH18及之后的补丁，通过
        if version == VERSION_612 and \
                compare_patch_version(patch_version, DEST_PATCH_VERSION_612) >= 0:
            return CheckStatus.PASS, ""

        # 6.1.3安装了SPH3及之后的补丁，通过
        if version == VERSION_613 and \
                compare_patch_version(patch_version, DEST_PATCH_VERSION_613) >= 0:
            return CheckStatus.PASS, ""

        # 检查方法步骤3：执行命令"show fs_hyper_metro_domain general"获取双活的工作模式
        fs_hyper_metro_domain_info = self.dsl("exec_cli 'show fs_hyper_metro_domain general' | horizontal_parser")
        is_sync_mode = self.has_sync_workmode(fs_hyper_metro_domain_info)
        cur_version = version + '.' + patch_version if patch_version and patch_version != '--' else version
        if is_sync_mode:
            return CheckStatus.NOT_PASS, self.get_msg("check.not.pass", cur_version)

        return CheckStatus.PASS, ""
