# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus

# 定义会话数的上限预置巡检
OM_SESSION_THRESHOLD = 70
# 定义会话数配置最小默认会话数
MIN_OM_SESSION_CHECK_NUM = 32


class CheckItem(BaseCheckItem):

    # 获取当前在线会话数数量
    def get_local_session_num(self):
        local_session_info = self.dsl("exec_mini_system 'om_show_omm_info.sh -q' | splitlines",
                                      end_str_list=["minisystem>", "minisystem> "])
        if len(local_session_info) < 3:
            return 0
        return len(local_session_info) - 3

    # 获取当前配置的会话数数量
    def get_config_session_num(self):
        session_info = self.dsl("exec_cli 'show user_session number' | vertical_parser")
        config_sessino_num = session_info[0].get("Session Number")
        return config_sessino_num

    def execute(self):
        config_sessino_num = self.get_config_session_num()
        if int(config_sessino_num) != MIN_OM_SESSION_CHECK_NUM:
            return CheckStatus.PASS, ""
        local_session_num = self.get_local_session_num()
        # 当前会话*100比例除以总会话小于70比例则返回成功。预留10个会话数给云核场景需求。
        if (local_session_num * 100 / int(config_sessino_num)) < OM_SESSION_THRESHOLD:
            return CheckStatus.PASS, ""
        return CheckStatus.NOT_PASS, self.get_msg("check.not.pass")