# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.

from com.huawei.ism.tool.bizpack.wizardparse.intf import GetUserInputImpl
from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.dsl.dsl_common import get_version_info
from psdk.platform.util.product_util import compare_patch_version

# 产品版本对应的补丁版本map
pass_version_dict = {
    '6.1.0': 'SPH36',
    '6.1.2': 'SPH52',
    '6.1.5': 'SPH18',
    '1.2.0': 'SPH18'
}


class CheckItem(BaseCheckItem):
    def execute(self):
        # 获取基本信息
        version_info = get_version_info(self.dsl)
        base_version = version_info.get("base_version").get("Current Version")
        patch_version = version_info.get("patch_version").get("Current Version")

        # 执行检查
        pass_version = pass_version_dict.get(base_version, "")
        if not pass_version or compare_patch_version(patch_version, pass_version) >= 0:
            return CheckStatus.PASS, ""

        msg = self.get_msg("check.ctrl.time.dialog", base_version, patch_version, pass_version)

        # 提供窗口供客户选择    
        dialog = GetUserInputImpl()
        rec = dialog.showWarningDialog(msg)

        # 弹框点击“确定”，检查通过
        if rec:
            return CheckStatus.PASS, ""
        # 弹框点击“取消”，检查不通过
        else:
            return CheckStatus.NOT_PASS, self.get_msg("check.not.pass", base_version, patch_version, pass_version)
