# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.dsl import fault_mode as ft
from psdk.platform.util.base_util import get_common_msg


class CheckItem(BaseCheckItem):
    def execute(self):
        disk_domain_scale_in_tasks = self.dsl("exec_developer 'show disk_domain_scale_in_task general' "
                                              "| horizontal_parser", return_if={ft.FindStr("Error"): "not_check"})
        if disk_domain_scale_in_tasks == 'not_check':
            return CheckStatus.NOT_CHECK, get_common_msg(self.lang, "query.result.abnormal")
        domain_ids = [
            disk_domain_info.get('Domain ID')
            for disk_domain_info in disk_domain_scale_in_tasks
            if disk_domain_info.get('Task Status') != 'Finish'
        ]
        if domain_ids:
            return CheckStatus.NOT_PASS, self.get_msg("check.not.pass", ', '.join(domain_ids))
        return CheckStatus.PASS, ""
