# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.platform.protocol.cli_common import get_system_version_without_ret
from psdk.platform.util.product_util import compare_patch_version


class CheckItem(BaseCheckItem):
    def execute(self):
        if self.check_version():
            return CheckStatus.PASS, ""
        domains = self.dsl("exec_cli 'show disk_domain general |filterColumn include columnList=ID' "
                           "| horizontal_parser")
        if not domains:
            self.logger.info("no domains. check pass")
            return CheckStatus.PASS, ""
        domain_ids = [item.get("ID") for item in domains]
        for domain_id in domain_ids:
            switch_status = self.dsl("exec_developer 'show disk_domain bgr_task_switch disk_domain_id={} task_type=rc'"
                              "| vertical_parser".format(domain_id))
            switchs = [item.get("Switch Status").lower() for item in switch_status]
            if "on" in switchs:
                return CheckStatus.NOT_PASS, self.get_msg("check.not.pass")
        return CheckStatus.PASS, ""

    def check_version(self):
        # 获取版本信息
        flag, software_version, hot_patch_version = \
            get_system_version_without_ret(self.dsl("exec_cli 'show upgrade package'"))
        if any([software_version == "6.0.1" and compare_patch_version(hot_patch_version, "SPH25") >= 0,
                software_version == "6.1.0" and compare_patch_version(hot_patch_version, "SPH15") >= 0,
                software_version == "6.1.3" and compare_patch_version(hot_patch_version, "SPH5") >= 0,
                software_version == "1.0.0", software_version == "6.1.2"]):
            return True
        return False
