# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.dsl.dsl_common import get_version_info
from psdk.platform.util.product_util import compare_patch_version

NO_FILE_SYSTEM = "No matching records"


class CheckItem(BaseCheckItem):
    def execute(self):
        # 执行命令：show file_system general，获取文件系统信息,若不存在文件系统信息，返回通过
        file_system_info = self.dsl("exec_cli 'show file_system general'")
        if NO_FILE_SYSTEM in file_system_info:
            return CheckStatus.PASS, ""

        # 获取查询当前阵列产品版本
        version_info = get_version_info(self.dsl)
        if not version_info:
            self.logger.info("no version info. check pass")
            return CheckStatus.PASS, ""

        # 获取产品版本和补丁版本,获取不到产品版本和补丁版本返回不通过
        pro_version = version_info.get("base_version").get("Current Version")
        sph_version = version_info.get("patch_version").get("Current Version")
        if not pro_version or not sph_version:
            return CheckStatus.NOT_PASS, self.get_msg("check.not.pass.version")

        # 如果是6.1.2版本判断当前版本补丁版本SPH32比较，如果大于等于则通过，否则不通过、
        if pro_version == "6.1.2" and \
                compare_patch_version(sph_version, "SPH32") >= 0:
            return CheckStatus.PASS, ""

        # 如果是6.1.3版本判断当前版本补丁版本SPH26比较，如果大于等于则通过，否则不通过、
        if pro_version == "6.1.3" and \
                compare_patch_version(sph_version, "SPH26") >= 0:
            return CheckStatus.PASS, ""

        # 如果是6.1.5或者OceanProtect 1.2.0版本判断当前版本补丁版本SPH10比较，如果大于等于则通过，否则不通过、
        if (pro_version == "6.1.5" or pro_version == "1.2.0") and \
                compare_patch_version(sph_version, "SPH10") >= 0:
            return CheckStatus.PASS, ""

        # 不存在存储池，则检查通过
        exp_disk_list = self.context.execute_env.ori_env.get("exp_disk_list")
        if not exp_disk_list:
            exp_disk_list = self.context.execute_env.ori_env.get("expDiskList")
        if not exp_disk_list:
            return CheckStatus.PASS, ""

        #  查看是否选择新建池，如果选择已有池，检查失败，如果选择新建池，检查通过
        for exp_disk in exp_disk_list:
            # 新建硬盘域场景，硬盘域id为空，这种场景不检查
            disk_domain = exp_disk.get("diskDomain")
            if disk_domain and disk_domain != 'none':
                return CheckStatus.NOT_PASS, self.get_msg("check.not.pass")
        return CheckStatus.PASS, ""
