# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.dsl.dsl_common import get_version_info
from psdk.platform.util.product_util import compare_patch_version

REP_LOWOJ_ID_LEN = 9
MAX_PAIR_NUM = 200
PASS_VERSION_DIC = {
    "6.0.0": "--",
    "6.0.1": "--",
    "6.1.0": "--",
    "6.1.2": "--",
}


class CheckItem(BaseCheckItem):
    def execute(self):
        # 检查方法步骤1：检查补丁版本号是否满足要求
        base_version = self.check_patch_version()
        if not base_version:
            return CheckStatus.PASS, ""

        # 遍历rms和rephc查询结果，不一样则返错
        pair_flag = self.dsl("exec_on_all {}", self.get_pair_flag, base_version)
        for _, ab_nodes in pair_flag.items():
            if ab_nodes and ab_nodes != [MAX_PAIR_NUM]:
                return CheckStatus.NOT_PASS, self.get_msg("check.not.pass")
            if ab_nodes == [MAX_PAIR_NUM]:
                return CheckStatus.WARNING, self.get_msg("item.suggestion")
        return CheckStatus.PASS, ""

    def check_patch_version(self):
        version_info = get_version_info(self.dsl)
        software_version = version_info.get("base_version").get("Current Version")

        if software_version not in PASS_VERSION_DIC:
            return ""

        return software_version

    def get_pair_flag(self, base_version):
        res = []
        pair_index = []
        cls_info = ""
        # 获取节点nodeId
        cls_info_s = self.dsl("exec_diagnose 'rsf showcls' | vertical_parser")
        if not cls_info_s:
            return []
        lows_version = list(PASS_VERSION_DIC.keys())
        lows_version.sort()
        low_version = lows_version[0:2]
        self.logger.info("base_version {},patch_version {}. pmsLun check pass".format(base_version, low_version))
        # 不同版本使用不同解析
        cls_info = cls_info_s[0].get("local node id")

        if cls_info and str(base_version) in low_version:
            pair_index = self.get_hyper_pair_index_old(cls_info)
        else:
            pair_index = self.get_hyper_pair_index_new(cls_info)

        for index in pair_index[0: 201]:
            pair_flag = self.dsl("exec_diagnose 'rephc querypair {}' | vertical_parser".format(index))
            for flag in pair_flag:
                if not flag.get('pairID'):
                    res.append(flag.get("pairID"))
                    return res
        if len(pair_index) > MAX_PAIR_NUM:
            return [MAX_PAIR_NUM]
        return res

    def get_hyper_metro_num(self, rms_info):
        pair_num = 0
        for rms_line in rms_info:
            if rms_line.split(":")[0].strip() == "type(0)totalObjNum":
                pair_num = int(rms_line.split(":")[1].strip())
        return pair_num

    def get_hyper_pair_index_new(self, cls_info):
        loop_flag = 1
        start_num = 0
        end_num = MAX_PAIR_NUM
        pair_index = []
        while loop_flag < 200:
            loop_flag += 1
            rms_info = self.dsl("exec_diagnose 'rsf showrms {} {} {}' |"
                                " splitlines".format(cls_info, str(start_num), str(end_num)))
            # # 获取双活数量
            pair_num = self.get_hyper_metro_num(rms_info)
            # 获取双活localId
            for rms_line in rms_info[::-1]:
                if rms_line.split("|")[0].strip().endswith(":/diagnose>"):
                    continue
                # 当解析出来第一个字段不为空，则表示当前节点没有rms对象，停止检查
                if rms_line.split("|")[0].strip():
                    loop_flag = 200
                    break
                modify_flag = rms_line.split("|")[1].strip()
                lowoj_id = rms_line.split("|")[6].strip()
                obj_index = rms_line.split("|")[8].strip()
                # 获取objId，当modifyFlag字段不是数值时停止遍历
                if modify_flag == "modifyFlag":
                    break
                if modify_flag.isdigit() and len(lowoj_id) < REP_LOWOJ_ID_LEN and obj_index not in pair_index:
                    pair_index.append(obj_index)
                if len(pair_index) > MAX_PAIR_NUM or len(pair_index) >= pair_num:
                    break
            if len(pair_index) > MAX_PAIR_NUM or len(pair_index) >= pair_num:
                break
            start_num += 200
            end_num += 200
        self.logger.info("have get pair num {}, pair num{}.".format(pair_index, pair_num))
        return pair_index

    def get_hyper_pair_index_old(self, cls_info):
        loop_flag = 1
        start_num = 0
        end_num = MAX_PAIR_NUM
        pair_index = []
        while loop_flag < 200:
            loop_flag += 1
            rms_info = self.dsl("exec_diagnose 'rsf showrms {} {} {}' |"
                                " splitlines".format(cls_info, str(start_num), str(end_num)))
            # # 获取双活数量
            pair_num = self.get_hyper_metro_num(rms_info)
            # 获取双活localId
            for rms_line in rms_info[::-1]:
                if rms_line.split("|")[0].strip().endswith(":/diagnose>"):
                    continue
                # 当解析出来第一个字段不为空，则表示当前节点没有rms对象，停止检查
                if rms_line.split("|")[0].strip():
                    loop_flag = 200
                    break
                modify_flag = rms_line.split("|")[1].strip()
                lowoj_id = rms_line.split("|")[4].strip()
                obj_index = rms_line.split("|")[6].strip()
                # 获取objId，当modifyFlag字段不是数值时停止遍历
                if modify_flag == "modifyFlag":
                    break
                if modify_flag.isdigit() and len(lowoj_id) < REP_LOWOJ_ID_LEN and obj_index not in pair_index:
                    pair_index.append(obj_index)
                if len(pair_index) > MAX_PAIR_NUM or len(pair_index) >= pair_num:
                    break
            if len(pair_index) > MAX_PAIR_NUM or len(pair_index) >= pair_num:
                break
            start_num += 200
            end_num += 200
        self.logger.info("have get pair num {}, pair num{}.".format(pair_index, pair_num))
        return pair_index