# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.
from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.dsl.dsl_common import get_version_info
from psdk.platform.util.product_util import compare_patch_version
from psdk.dsl import fault_mode as ft
from psdk.platform.util.product_util import compare_version
 
 
PASS_VERSION_DIC = {
    "6.1.2": "SPH66",
    "6.1.5": "SPH33",
    "6.1.6": "SPH18",
    "6.1.7": "SPH6",
}

VERSION_V6_618 = "6.1.8"


class CheckItem(BaseCheckItem):
    def execute(self):
        # 检查方法步骤1：检查补丁版本号是否满足要求
        version_info = get_version_info(self.dsl)
        patch_version = version_info.get("patch_version").get("Current Version")
        software_version = version_info.get("base_version").get("Current Version")
        self.logger.info("base_version {},patch_version {}. pmsLun check pass".format(software_version, patch_version))

        # 检查版本软件6.1.8或之后版本通过
        if compare_version(software_version, VERSION_V6_618) >= 0:
            return CheckStatus.PASS, ""
        if software_version in PASS_VERSION_DIC:
            if compare_patch_version(patch_version, PASS_VERSION_DIC[software_version]) >= 0:
                return CheckStatus.PASS, ""

        # 检查方法步骤2：查询所有创建了san双活的lun，查询所有创建了san远程复制的lun，比较lun是否有重复的，存在则说明创建了3dc，检查不通过
        hc_lun_informations = self.dsl("exec_cli"
            "'show hyper_metro_pair general |filterColumn include columnList=Local\sID|filterRow"
            " column=Type predict=match value=LUN' | horizontal_parser",
            return_if={ft.FindStr("No matching records"): "not_support"})
        self.logger.info("the hc_lun_informations info is {}".format(hc_lun_informations))
        if hc_lun_informations == "not_support":
            return CheckStatus.PASS, ""
        
        rm_lun_informations = self.dsl("exec_cli"
            "'show remote_replication general |filterColumn include columnList=Local\sLUN\sID' | horizontal_parser",
            return_if={ft.FindStr("No matching records"): "not_support"})
        self.logger.info("the rm_lun_informations info is {}".format(rm_lun_informations))
        if rm_lun_informations == "not_support":
            return CheckStatus.PASS, ""

        # 比较双活和远程复制是否有重复LUN使用
        hc_lun_map = {}
        for hc_item in hc_lun_informations:
            hc_lun_id = hc_item.get("Local ID", "")
            hc_lun_map[hc_lun_id] = hc_lun_id
   
        for rm_item in rm_lun_informations:
            rm_lun_id = rm_item.get("Local LUN ID", "")
            if not hc_lun_map.get(rm_lun_id):
                continue
            if rm_lun_id == hc_lun_map.get(rm_lun_id):
                self.logger.info("3dc configured, lun is {}".format(rm_lun_id))
                return CheckStatus.NOT_PASS, self.get_msg("check.not.pass")

        return CheckStatus.PASS, ""