# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.dsl.dsl_common import get_version_info
from psdk.platform.entity.check_status import CheckStatus

CHECK_VERSION = "6.0.0"


class CheckItem(BaseCheckItem):
    @staticmethod
    def has_pair_id(pair_info):
        """
        检查标准1：是否含有远程复制pair
        """
        for pair in pair_info:
            if pair.get("ID"):
                return True
        return False

    def execute(self):
        # 查询系统软件版本和热补丁版本信息
        version_info = get_version_info(self.dsl)
        patch_version = version_info.get("patch_version").get("Current Version")
        version = version_info.get("base_version").get("Current Version")

        if version != CHECK_VERSION:
            return CheckStatus.PASS, ""

        # 检查方法步骤3：执行命令"show remote_replication general"查询远程复制pair信息
        pair_info = self.dsl("exec_cli 'show remote_replication general' | horizontal_parser")
        has_pair = self.has_pair_id(pair_info)
        cur_version = version + '.' + patch_version if patch_version and patch_version != '--' else version
        if has_pair:
            return CheckStatus.NOT_PASS, self.get_msg("check.not.pass", cur_version)

        return CheckStatus.PASS, ""
