# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.

import re
from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.dsl.dsl_common import get_version_info
from psdk.platform.entity.base_context import DevNode
from psdk.platform.entity.check_status import CheckStatus

from psdk.platform.util.product_util import compare_version, compare_patch_version

product_base_version_tuple = ("1.2.0", "1.3.0", "1.2.1")
product_patch_version_tuple = ("SPH36", "SPH6")
product_model_info_tuple = (
    'OceanProtect A8000', 'OceanProtect X8000', 'OceanProtect X9000', 'OceanProtect X8000K', 'OceanProtect E8000',
    'OceanProtect X3000', 'OceanProtect X9000K', 'OceanProtect X6000'
)
product_patch_version_tuple_120 = (
    "SPH1", "SPH2", "SPH3", "SPH4", "SPH5", "SPH6", "SPH7", "SPH8", "SPH9", "SPH10", "SPH11",
    "SPH12", "SPH13", "SPH14", "SPH15", "SPH16", "SPH17", "SPH18", "SPH19", "SPH20", "SPH21",
    "SPH22", "SPH23", "SPH24", "SPH25", "SPH26", "SPH27", "SPH28", "SPH29", "SPH30", "SPH31",
    "SPH32", "SPH33", "SPH34", "SPH35"
)

product_patch_version_tuple_130 = ("SPH1", "SPH2", "SPH3", "SPH4", "SPH5")

product_patch_version_tuple_121 = ("SPH1", "SPH2", "SPH3")


class CheckItem(BaseCheckItem):

    @staticmethod
    # 检查是否是混闪
    def is_mixed_flash(disk_info_list):
        has_ssd = False
        has_sas = False
        for disk_info in disk_info_list:
            disk_type = disk_info.get("Type")
            if "SSD" in disk_type:
                has_ssd = True
            if "SAS" in disk_type:
                has_sas = True
        return has_ssd and has_sas

    def execute(self):
        # 检查方法步骤1：查看型号是否匹配
        model = self.context.dev_node.model
        if model not in product_model_info_tuple:
            return CheckStatus.PASS, ""

        # 检查方法步骤2：查看版本信息是否匹配
        version_info = get_version_info(self.dsl)
        pro_version = version_info.get("base_version").get("Current Version")
        patch_version = version_info.get("patch_version").get("Current Version")
        version_flag = False
        no_patch_version = '--'
        # 检查版本
        if pro_version not in product_base_version_tuple:
            return CheckStatus.PASS, ''
        # 检查补丁版本
        if compare_version(pro_version, '1.2.1') == 0:
            if patch_version == no_patch_version:
                version_flag = True
            if patch_version in product_patch_version_tuple_121:
                version_flag = True
        if compare_version(pro_version, '1.2.0') == 0:
            if patch_version == no_patch_version:
                version_flag = True
            if patch_version in product_patch_version_tuple_120:
                version_flag = True
        if compare_version(pro_version, '1.3.0') == 0:
            if patch_version == no_patch_version:
                version_flag = True
            if patch_version in product_patch_version_tuple_130:
                version_flag = True
        # 检查方法步骤3：执行命令"show disk general"查询硬盘信息
        disk_info_list = self.dsl("exec_cli 'show disk general|filterColumn include columnList=ID,Disk\sDomain\sID,"
                                  "Type,AutoLock\sState'"
                                  " | horizontal_parser")
        flag_disk = self.is_mixed_flash(disk_info_list)

        if version_flag:
            if flag_disk:
                return CheckStatus.NOT_PASS, self.get_msg("check.not.pass")

        return CheckStatus.PASS, ""
