# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.dsl.dsl_common import get_version_info
from psdk.platform.util.product_util import compare_patch_version


class CheckItem(BaseCheckItem):
    def execute(self):
        # 检查方法步骤1/2：使用dsl执行命令查询版本信息
        version_info = get_version_info(self.dsl)
        patch_version = version_info.get("patch_version").get("Current Version")

        if compare_patch_version(patch_version, "SPH12") >= 0:
            return CheckStatus.PASS, ""

        # 检查方法步骤3：show snapshot general，查看是否配置快照
        record = self.dsl("exec_cli 'show snapshot general'")
        if self.not_match(record):
            return CheckStatus.NOT_PASS, self.get_msg("check.not.pass")

        # 检查方法步骤4：show hyper_cdp general，查看是否配置定时快照
        record = self.dsl("exec_cli 'show clone general'")
        if self.not_match(record):
            return CheckStatus.NOT_PASS, self.get_msg("check.not.pass")

        # 检查方法步骤5：show clone general，查看是否配置克隆
        record = self.dsl("exec_cli 'show hyper_cdp general'")
        if self.not_match(record):
            return CheckStatus.NOT_PASS, self.get_msg("check.not.pass")

        # 检查方法步骤6：show remote_replication general，查看是否配置远程复制
        record = self.dsl("exec_cli 'show remote_replication general'")
        if self.not_match(record):
            return CheckStatus.NOT_PASS, self.get_msg("check.not.pass")
        return CheckStatus.PASS, ""

    @staticmethod
    def not_match(record):
        """
        判断查询结果，是否存在记录
        """
        if 'No matching records' not in record:
            return True
        return False
