# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.dsl.dsl_common import get_version_info
from psdk.platform.util.product_util import compare_patch_version

VER_DICT = {'6.1.0': 'SPH20', '6.1.2': 'SPH9'}


class CheckItem(BaseCheckItem):
    def execute(self):
        version_info = get_version_info(self.dsl)
        software_version = version_info.get("base_version").get("Current Version")
        hotpatch_version = version_info.get("patch_version").get("Current Version")
        self.logger.info(
            "the software_version is: {}, the hotpatch_version is: {}".format(software_version, hotpatch_version))
        if compare_patch_version(hotpatch_version, VER_DICT.get(software_version)) < 0:
            return CheckStatus.NOT_PASS, self.get_msg("check.not.pass", software_version, hotpatch_version)
        return CheckStatus.PASS, ""
