# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus


DEGREE_NOT_PASS = 98.0
DEGREE_SUGG = 90.0


class CheckItem(BaseCheckItem):
    def execute(self):
        disk_info_list = self.dsl("exec_cli 'show disk general|filterColumn include columnList=ID,Model,Type,"
                                  "Manufacturer,Estimated\sLife\sRemaining(Month),Degree\sof\sWear(%)'"
                                  " | horizontal_parser")
        if not disk_info_list:
            return CheckStatus.PASS, ""

        replace_disk, suggest_backup_disk = self.check_disk_degree_wear(disk_info_list)
        if replace_disk:
            return CheckStatus.NOT_PASS, self.get_total_err_msg(replace_disk, suggest_backup_disk)
        if suggest_backup_disk:
            return CheckStatus.WARNING, self.get_total_err_msg(replace_disk, suggest_backup_disk)
        return CheckStatus.PASS, ""

    def check_disk_degree_wear(self, disk_info_list):
        replace_disk = []
        suggest_backup_disk = []
        for disk_info in disk_info_list:
            degree_wear = disk_info.get("Degree of Wear(%)", "0")
            if self.get_degree_wear(degree_wear) >= DEGREE_NOT_PASS:
                replace_disk.append(disk_info.get("ID"))
            elif self.get_degree_wear(degree_wear) >= DEGREE_SUGG:
                suggest_backup_disk.append(disk_info.get("ID"))
        return replace_disk, suggest_backup_disk

    def get_total_err_msg(self, replace_disk, suggest_backup_disk):
        err_msg = []
        if replace_disk:
            err_msg.append(self.get_msg("check.not.pass", ", ".join(replace_disk)))
        if suggest_backup_disk:
            err_msg.append(self.get_msg("check.suggestion", ", ".join(suggest_backup_disk)))
        return "\n".join(err_msg)

    def get_degree_wear(self, degree_str):
        try:
            return float(degree_str)
        except ValueError:
            self.logger.error("not a float value")
            return 0

