# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.dsl.dsl_common import get_version_info
from psdk.platform.entity.check_status import CheckStatus

PASS_VERSION_V3R6C50 = "V300R006C50SPC100"
PASS_PATCH_VERSION_V3R6C50 = "V300R006C50SPH106"
PASS_VERSION_V3R6C20 = "V300R006C20"
PASS_PATCH_VERSION_V3R6C20 = "V300R006C20SPH050"
NOT_PASS_MODEL = "HUSMM1640ASS204"


class CheckItem(BaseCheckItem):

    def execute(self):
        # 步骤2 获取系统软件版本和热补丁版本
        version_info = get_version_info(self.dsl)
        patch_version = version_info.get("patch_version").get("Current Version")
        version = version_info.get("base_version").get("Current Version")
        # 若步骤2中软件版本和热补丁版本为V300R006C50SPC100、V300R006C50SPH106及之后补丁，则检查结果为通过，否则继续检查
        if version == PASS_VERSION_V3R6C50 and patch_version >= PASS_PATCH_VERSION_V3R6C50:
            return CheckStatus.PASS, ""
        # 若步骤2中软件版本和热补丁版本为V300R006C20、V300R006C20SPH050及之后补丁，则检查结果为通过，否则继续检查
        if version == PASS_VERSION_V3R6C20 and patch_version >= PASS_PATCH_VERSION_V3R6C20:
            return CheckStatus.PASS, ""
        # 步骤3 执行命令：show disk general |filterColumn include columnList=Model,ID，获取硬盘model信息。
        model_info = self.dsl(
            "exec_cli 'show disk general |filterColumn include columnList=Model,ID' | horizontal_parser"
        )
        # 若步骤3中获取到的硬盘model信息存在HUSMM1640ASS204，则检查结果为不通过，否则检查结果为通过
        if self.has_not_pass_model(model_info):
            return CheckStatus.NOT_PASS, self.get_msg("check.not.pass")

        return CheckStatus.PASS, ""

    @staticmethod
    def has_not_pass_model(model_info):
        """
        model是否含有HUSMM1640ASS204
        """
        for model in model_info:
            if NOT_PASS_MODEL == model.get("Model"):
                return True
        return False
