# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.
import ast
from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus


class CheckItem(BaseCheckItem):
    def execute(self):
        self.logger.info("Checking the redundancy of switch before replace.")
        try:
            selected_fru = ast.literal_eval(self.context.execute_env.selected_fru)
            cur_plane = selected_fru.get("plane")
        except Exception as e:
            self.logger.error("Get plane Id from selected_fru failed.")
            return CheckStatus.NOT_PASS, self.get_err_msg("check.not.pass", "item.suggestion.switchId")

        return self.check_switch_redundancy(plane=cur_plane)

    def check_switch_redundancy(self, plane):
        check_result = self.dsl("exec_diagnose 'eam lhacheckswitchlink {} curr -devm' | vertical_parser".format(plane))
        result = check_result[0].get("Check switch plane {} link result".format(plane)).strip()
        if result == "Normal.":
            return CheckStatus.PASS, ""
        return CheckStatus.NOT_PASS, self.get_err_msg("check.not.pass", "item.suggestion")
