# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2023. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.platform.protocol.rest.rest_service import RestService
from psdk.platform.protocol.rest import a800_rest_service


# DME需要检查的告警ID
DME_CHECK_ALARM_WHITELIST = set([
    '14155777', # 存储池剩余容量不足
    '14155778', # 存储池容量即将耗尽
    '2621511',  # 文件系统剩余容量不足。重要
    '14156057', # 存储池剩余容量不足
    '14156104',  # 可得容量消耗不符合预期
    '14680120',  # 存储池可用空间耗尽。紧急
    '17104917', # 交换机无法监控
    '17432665',  # 硬盘域热备空间不足。重要
    '2819',  # 存储池热备空间不足。重要
])


class CheckItem(BaseCheckItem):
    """
    检查设备上是否存在特定告警
    """
    def execute(self):
        dme_info = self.context.execute_env.ori_env.get("dmeInfo")
        all_alarm_list = []
        iterator = 0
        while True:
            result, iterator = self.query_current_alarm(dme_info, iterator)
            if not result:
                break    
            all_alarm_list.extend(result)
        if all_alarm_list:
            return CheckStatus.NOT_PASS, self.get_err_msg("check.not.pass", "item.suggestion", \
                err_args=(",".join(all_alarm_list)))
        else:
            return CheckStatus.PASS, ""


    """
    查询DME当前告警信息, 迭代查询 每次最多返回1000条
    """
    def query_current_alarm(self, dme_info, iterator):
        data = {}
        if iterator == 0:
            data = a800_rest_service.get_a800_dme_rest_response(dme_info, "POST", \
                "/rest/alarmmgmt/v1/alarms/current-alarm/query", {})
        else:
            param_obj = {
                "iterator": iterator
            }
            data = a800_rest_service.get_a800_dme_rest_response(dme_info, "POST", \
                "/rest/alarmmgmt/v1/alarms/current-alarm/query", param_obj)
        if not data:
            # 表示没有这些告警
            return [], ""
        hits = data.get("hits")
        call_iter = data.get("iterator")
        if not hits:
            # 表示没有这些告警
            return [], ""
        cur_alarm_list = []
        for hit in hits:
            # cleared等于0表示告警未清除，acked等于0表示告警未确认alarmGroupId告警应该是来自A800的告警组278411631
            if int(hit.get("cleared")) == 0 and int(hit.get("acked")) == 0 and \
                int(hit.get("alarmGroupId")) == 278411631:
                alarm_id = hit.get("alarmId")
                if alarm_id in DME_CHECK_ALARM_WHITELIST:
                    cur_alarm_list.append(alarm_id)
        return cur_alarm_list, call_iter